package code.branchDetecting.unit;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.Vector;

import code.AcceptStamp;
import code.Config;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.SummaryHash;
import code.branchDetecting.BranchID;
import code.branchDetecting.SegmentGroup;
import code.branchDetecting.SegmentGroups;
import code.security.DataHash;
import code.security.SecurePreciseInv;
import code.security.ahs.DependencyVV;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import code.simulator.*;

public class BranchDetectorUnit extends TestCase{

  Vector<SecurePreciseInv> invals_b0_0to9 = new Vector<SecurePreciseInv>();
  Vector<SecurePreciseInv> invals_b0_10to19_a = new Vector<SecurePreciseInv>();
  Vector<SecurePreciseInv> invals_b0_10to19_b = new Vector<SecurePreciseInv>();
  Vector<SecurePreciseInv> invals_b1_0 = new Vector<SecurePreciseInv>();
  Vector<SecurePreciseInv> invals_b1_1 = new Vector<SecurePreciseInv>();
  
  protected void setUp() throws Exception{
    super.setUp();
    
    PrivateKey privKey;
    PublicKey pubKey;
    NodeId nodeId;

    byte[] hash = new byte[]{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
    nodeId = new BranchID(10);
    
    byte[] buffer;
    byte[] buffer2;
    Config.readKeys();
    privKey = (PrivateKey)Config.privateKeys.get(new Long(nodeId.getIDint()));
    pubKey = (PublicKey)Config.publicKeys.get(new Long(nodeId.getIDint()));

    buffer = new byte[]{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
    buffer2 = new byte[]{10,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,19};

    SummaryHash sh = new SummaryHash();
    sh.putValue(buffer);
    DataHash dh = new DataHash();
    dh.putHashVal(buffer2);
    
    for(int i=0; i < 10; i++){
      DependencyVV dvv = new DependencyVV();
      dvv.put(nodeId, i-1);

      SecurePreciseInv spi =
        new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand0/"+i), 5, 10) ,
            new AcceptStamp(i, nodeId),
            new AcceptStamp(i, nodeId),
            false, dvv, sh, dh, privKey);

      invals_b0_0to9.add(spi);
      //ahsMap.applySecurePreciseInv(spi);
      //copyAHSMap.applySecurePreciseInv(spi);
      //FilterKnowledge fk = ahsMap.getKnowledge().getFilterKnowledge(f);
      //assert fk.getCVV().includes(spi.getAcceptStamp()): fk;
      //assert !fk.getHoles().containsKey(nodeId) || fk.getHoles().get(nodeId).isEmpty(): fk;
    }
    
    for(int i=10; i < 20; i++){
      DependencyVV dvv = new DependencyVV();
      dvv.put(nodeId, i-1);

      SecurePreciseInv spi =
        new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand0a/"+i), 5, 10) ,
            new AcceptStamp(i, nodeId),
            new AcceptStamp(i, nodeId),
            false, dvv, sh, dh, privKey);

      invals_b0_10to19_a.add(spi);
    }
    for(int i=10; i < 20; i++){
      DependencyVV dvv = new DependencyVV();
      dvv.put(nodeId, i-1);

      SecurePreciseInv spi =
        new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand0b/"+i), 5, 10) ,
            new AcceptStamp(i, nodeId),
            new AcceptStamp(i, nodeId),
            false, dvv, sh, dh, privKey);

      invals_b0_10to19_b.add(spi);
    }
    for(int i=10; i < 20; i++){
      BranchID bid1 = new BranchID(nodeId.getIDint(), 10, new Hash(buffer, false));
      DependencyVV dvv = new DependencyVV();
      if(i==10)
        dvv.put(nodeId, i-1);
      else
        dvv.put(bid1, i-1);
      

      SecurePreciseInv spi =
        new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand0_b0/"+i), 5, 10) ,
            new AcceptStamp(i, bid1),
            new AcceptStamp(i, bid1),
            false, dvv, sh, dh, privKey);

      invals_b1_0.add(spi);
    }
    
    for(int i=10; i < 20; i++){
      BranchID bid2 = new BranchID(nodeId.getIDint(), 10, new Hash(buffer2, false));
      DependencyVV dvv = new DependencyVV();
      if(i==10)
        dvv.put(nodeId, i-1);
      else
        dvv.put(bid2, i-1);
      

      SecurePreciseInv spi =
        new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand0_b1/"+i), 5, 10) ,
            new AcceptStamp(i, bid2),
            new AcceptStamp(i, bid2),
            false, dvv, sh, dh, privKey);

      invals_b1_1.add(spi);
    }
    
  }

  protected void tearDown() throws Exception{
    super.tearDown();
  }
  
//  public void testDetectBranches(){
//    
//    TestNode tn1 = new TestNode();
//    TestNode tn2 = new TestNode();
//  
//    for(int i=0; i < 10; i++){
//      SecurePreciseInv spi = invals_b0_0to9.get(i);
//      tn1.applyInval(spi);
//      tn2.applyInval(spi);
//    }
//    
//    for(int i=0; i < 10; i++){
//      SecurePreciseInv spi = invals_b1_0.get(i);
//      tn1.applyInval(spi);
//      spi = invals_b1_1.get(i);
//      tn2.applyInval(spi);
//    }
//    
//    //System.out.println("*** Before comparison");
//    String TN1_before = tn1.getBranchKnowledge().toString();
//    String TN2_before = tn2.getBranchKnowledge().toString();
//    //System.out.println("###TESTNODE 1###\n" + tn1.getBranchKnowledge().toString());
//    //System.out.println("###TESTNODE 2###\n" +tn2.getBranchKnowledge().toString());
//    
//    tn1.getBranchDetector().registerReceiverSegementChecker(tn2.getSegmentCheckInterface());
//    tn1.getBranchDetector().detectBranches();
//    //System.out.println("*** After comparison");
//    //System.out.println("###TESTNODE 1###\n" + tn1.getBranchKnowledge().toString());
//    //System.out.println("###TESTNODE 2###\n" +tn2.getBranchKnowledge().toString());
//    assert TN1_before.equals(tn1.getBranchKnowledge().toString()) &&
//    TN2_before.equals(tn2.getBranchKnowledge().toString()) 
//    : "*** Before comparison\n" + "###TESTNODE 1###\n" + TN1_before +"\n"
//    + "###TESTNODE 2###\n" + TN2_before + "\n*** After comparison\n"
//    + "###TESTNODE 1###\n" + tn1.getBranchKnowledge().toString()+"\n"
//    + "###TESTNODE 2###\n" +tn2.getBranchKnowledge().toString()+"\n" ;
//
//  }
//
//  public void testDetectBranches2(){
//    
//    /*
//     * tn1 has single branch
//     * tn2 has forked branches which do not compatible with t1's
//     * i.e tn1 has a longer segment
//     */
//    System.out.println("testDetectBranch2");
//    TestNode tn1 = new TestNode();
//    TestNode tn2 = new TestNode();
//  
//    for(int i=0; i < 10; i++){
//      SecurePreciseInv spi = invals_b0_0to9.get(i);
//      tn1.applyInval(spi);
//      tn2.applyInval(spi);
//    }
//    
//    for(int i=0; i < 10; i++){
//      SecurePreciseInv spi = invals_b0_10to19_a.get(i);
//      tn1.applyInval(spi);
//      spi = invals_b1_0.get(i);
//      tn2.applyInval(spi);
//      spi = invals_b1_1.get(i);
//      tn2.applyInval(spi);
//    }
//    
//    System.out.println("*** Before comparison");
//    System.out.println("###TESTNODE 1###\n" + tn1.getBranchKnowledge().toString());
//    System.out.println("###TESTNODE 2###\n" +tn2.getBranchKnowledge().toString());
//    
//    tn1.getBranchDetector().registerReceiverSegementChecker(tn2.getSegmentCheckInterface());
//    tn1.getBranchDetector().detectBranches();
//    
//    // For tn1, the split segments must start at -1 and 10 
//    SegmentGroups sgs = tn1.getBranchKnowledge().getSegmentGroups(new BranchID(10));
//    assert sgs != null;
//    Iterator<SegmentGroup> itr = sgs.getIterator();
//    SegmentGroup sg = itr.next();
//    if (sg.getStartTS() != -1){      
//      fail(sg.toString());      
//    }
//    sg = itr.next();
//    if (sg.getStartTS() != 10){
//      fail(sg.toString());      
//    }
//    
//    System.out.println("*** After comparison");
//    System.out.println("###TESTNODE 1###\n" + tn1.getBranchKnowledge().toString());
//    System.out.println("###TESTNODE 2###\n" +tn2.getBranchKnowledge().toString());
//    
//    
//  }
//  public void testDetectBranches3(){
//    /*
//     * Scenario
//     * Node tn1 and tn2 have forked log of Node 10 at time stamp 10
//     * But tn1 and tn2 don't know about the forking point
//     * (i.e. they are common until time stamp 9)
//     */
//    System.out.println("testDetectBranch3");
//    TestNode tn1 = new TestNode();
//    TestNode tn2 = new TestNode();
//  
//    for(int i=0; i < 10; i++){
//      SecurePreciseInv spi = invals_b0_0to9.get(i);
//      tn1.applyInval(spi);
//      tn2.applyInval(spi);
//    }
//    
//    for(int i=0; i < 10; i++){
//      SecurePreciseInv spi = invals_b0_10to19_a.get(i);
//      tn1.applyInval(spi);
//      spi = invals_b0_10to19_b.get(i);
//      tn2.applyInval(spi);
//    }
//    
//    System.out.println("*** Before comparison");
//    System.out.println("###TESTNODE 1###\n" + tn1.getBranchKnowledge().toString());
//    System.out.println("###TESTNODE 2###\n" +tn2.getBranchKnowledge().toString());
//    
//    tn1.getBranchDetector().registerReceiverSegementChecker(tn2.getSegmentCheckInterface());
//    tn1.getBranchDetector().detectBranches();
//    
//    // For tn1, the split segments must start at -1 and 10 
//    SegmentGroups sgs = tn1.getBranchKnowledge().getSegmentGroups(new BranchID(10));
//    assert sgs != null;
//    Iterator<SegmentGroup> itr = sgs.getIterator();
//    SegmentGroup sg = itr.next();
//    if (sg.getStartTS() != -1){      
//      fail(sg.toString());      
//    }
//    sg = itr.next();
//    if (sg.getStartTS() != 10){
//      fail(sg.toString());      
//    }
//    // For tn1, the split segments must start at -1 and 10 
//    sgs = tn2.getBranchKnowledge().getSegmentGroups(new BranchID(10));
//    assert sgs != null;
//    itr = sgs.getIterator();
//    sg = itr.next();
//    if (sg.getStartTS() != -1){      
//      fail(sg.toString());      
//    }
//    sg = itr.next();
//    if (sg.getStartTS() != 10){
//      fail(sg.toString());      
//    }
//    System.out.println("*** After comparison");
//    System.out.println("###TESTNODE 1###\n" + tn1.getBranchKnowledge().toString());
//    System.out.println("###TESTNODE 2###\n" +tn2.getBranchKnowledge().toString());
//    
//    
//  }
//  public void testDetectBranches4(){
//    /*
//     * Scenario
//     * Node tn1 and tn2 have forked log of Node 10 at time stamp 10
//     * But tn1 and tn2 don't know about the forking point
//     * (i.e. they are common until time stamp 9)
//     */
//    System.out.println("testDetectBranch4");
//    TestNode tn1 = new TestNode();
//    TestNode tn2 = new TestNode();
//  
//    for(int i=0; i < 10; i++){
//      SecurePreciseInv spi = invals_b0_0to9.get(i);
//      tn1.applyInval(spi);
//      tn2.applyInval(spi);
//    }
//    
//    for(int i=0; i < 10; i++){
//      SecurePreciseInv spi = invals_b0_10to19_a.get(i);
//      tn1.applyInval(spi);
//      spi = invals_b0_10to19_b.get(i);
//      tn2.applyInval(spi);
//    }
//    
//    System.out.println("*** Before comparison");
//    System.out.println("###TESTNODE 1###\n" + tn1.getBranchKnowledge().toString());
//    System.out.println("###TESTNODE 2###\n" +tn2.getBranchKnowledge().toString());
//    
//    tn1.getBranchDetector().registerReceiverSegementChecker(tn2.getSegmentCheckInterface());
//    tn1.getBranchDetector().detectBranches();
//    
//    // For tn1, the split segments must start at -1 and 10 
//    SegmentGroups sgs = tn1.getBranchKnowledge().getSegmentGroups(new BranchID(10));
//    assert sgs != null;
//    Iterator<SegmentGroup> itr = sgs.getIterator();
//    SegmentGroup sg = itr.next();
//    if (sg.getStartTS() != -1){      
//      fail(sg.toString());      
//    }
//    sg = itr.next();
//    if (sg.getStartTS() != 10){
//      fail(sg.toString());      
//    }
//    // For tn1, the split segments must start at -1 and 10 
//    sgs = tn2.getBranchKnowledge().getSegmentGroups(new BranchID(10));
//    assert sgs != null;
//    itr = sgs.getIterator();
//    sg = itr.next();
//    if (sg.getStartTS() != -1){      
//      fail(sg.toString());      
//    }
//    sg = itr.next();
//    if (sg.getStartTS() != 10){
//      fail(sg.toString());      
//    }
//    System.out.println("*** After comparison");
//    System.out.println("###TESTNODE 1###\n" + tn1.getBranchKnowledge().toString());
//    System.out.println("###TESTNODE 2###\n" +tn2.getBranchKnowledge().toString());
//    
//    
//  }
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(BranchDetectorUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "BranchDetectorUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }
}
