package code.branchDetecting.unit;

import java.io.EOFException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.LinkedList;
import java.util.Vector;

import code.AcceptStamp;
import code.AcceptVV;
import code.BodyMsg;
import code.Config;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.ObjNotFoundException;
import code.RMIApplicationException;
import code.RMINetworkException;
import code.ReadOfHoleException;
import code.ReadOfInvalidRangeException;
import code.SubscriptionSet;
import code.SummaryHash;
import code.branchDetecting.BranchID;
import code.branchDetecting.BranchKnowledge;
import code.branchDetecting.BranchManager;
import code.branchDetecting.ConflictingSegmentsException;
import code.branchDetecting.ForkableAHSMap;
import code.branchDetecting.Segment;
import code.security.DataHash;
import code.security.SangminConfig;
import code.security.SecureCore;
import code.security.SecurePreciseInv;
import code.security.SecureURANode;
import code.security.SecurityFilter;
import code.security.ahs.DependencyVV;
import code.security.ahs.UnmatchingTreeNodeException;
import code.security.holesync.filter.Filter;
import code.security.holesync.filter.SubscriptionSetFilter;
import code.security.liveness.LivenessFilter;
import code.security.liveness.TrustedServerBlockingLivenessFilter;
import code.simulator.*;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BranchManagerUnit extends TestCase{

  private Vector<SecurePreciseInv> invals_b0_0to19 = new Vector<SecurePreciseInv>();
  String configpath = "./branchtestconfig";

  protected void setUp() throws Exception{
    super.setUp();

    PrivateKey privKey;
    PublicKey pubKey;
    NodeId nodeId;
    
    makeDummyConfig(configpath, 5);
    byte[] hash = new byte[]{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
    nodeId = new BranchID(10);

    byte[] buffer;
    byte[] buffer2;
    Config.readKeys();
    privKey = (PrivateKey)Config.privateKeys.get(new Long(nodeId.getIDint()));
    pubKey = (PublicKey)Config.publicKeys.get(new Long(nodeId.getIDint()));

    buffer = new byte[]{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
    buffer2 = new byte[]{10,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,19};

    SummaryHash sh = new SummaryHash();
    sh.putValue(buffer);
    DataHash dh = new DataHash();
    dh.putHashVal(buffer2);

    for(int i=0; i < 10; i++){
      DependencyVV dvv = new DependencyVV();
      dvv.put(nodeId, i-1);

      SecurePreciseInv spi =
        new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand0/"+i), 5, 10) ,
            new AcceptStamp(i, nodeId),
            new AcceptStamp(i, nodeId),
            false, dvv, sh, dh, privKey);

      invals_b0_0to19.add(spi);

      //ahsMap.applySecurePreciseInv(spi);
      //copyAHSMap.applySecurePreciseInv(spi);
      //FilterKnowledge fk = ahsMap.getKnowledge().getFilterKnowledge(f);
      //assert fk.getCVV().includes(spi.getAcceptStamp()): fk;
      //assert !fk.getHoles().containsKey(nodeId) || fk.getHoles().get(nodeId).isEmpty(): fk;
    }
    NodeId nodeId2 = new BranchID(20);
    NodeId lastUpdateNode = nodeId;
    NodeId id = nodeId;
    for(int i=10; i < 20; i++){
      DependencyVV dvv = new DependencyVV();
      dvv.put(lastUpdateNode, i-1);
      if(i%2 == 0)
        id = nodeId;
      else
        id = nodeId2;
      lastUpdateNode = id;
      SecurePreciseInv spi =
        new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand0/"+i), 5, 10) ,
            new AcceptStamp(i, id),
            new AcceptStamp(i, id),
            false, dvv, sh, dh, privKey);

      invals_b0_0to19.add(spi);
    }
  }
  protected void  makeDummyConfig(String path, int nNodes){

    // System.out.println("DBG: user.dir = " //MDD Debug jswat working dir
    // + System.getProperties().getProperty("user.dir")); 

    Config.createEmptyConfig();

    for(int i=10; i < 10 + nNodes; i++){
      NodeId id = new NodeId(i);
      Config.addOneNodeConfig(id, "localhost",
          2678+i, 3578+i, 4578+i, 5578+i, 6578+i, 
          "testBranchManager_"+i+".db", "/*", -1, 
          "localhost.cs.utexas.edu", 7078+i, 7578+i, -1,Config.CACHE_SIZE_BYTES_DEFAULT,
          Config.MAX_LOG_DISK_SIZE_BYTES, Config.MAX_LOG_MEM_SIZE_BYTES);
    }
    System.out.println("Config file for " + Config.getNumNodes() + " nodes created");
    Config.writeToFile(path);
  }

  public void testURANode(){
    /*
    Process rmiregistry = null;
    try{
      rmiregistry = Runtime.getRuntime().exec("rmiregistry");
    }catch(IOException e1){
      // TODO Auto-generated catch block
      e1.printStackTrace();
      fail();
    }    
    try{
      Thread.sleep(1000);
    }catch(InterruptedException e1){      
    }
    
    SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
    LinkedList<Filter> f = new LinkedList<Filter>();
    f.add(ssf);

    NodeId nid1 = new BranchID(new NodeId(10));
    LivenessFilter lf = new TrustedServerBlockingLivenessFilter(nid1);
    SecureURANode suran1 = new SecureURANode(configpath, nid1,
        code.Controller.NULL_CONTROLLER,true,lf,f);



    byte[] b = new byte[10];
    for(int i=0; i < b.length; i++){
      b[i] = 40;
    }
    for(int i=0; i < 10; i++){
      ObjId oid = new ObjId("/obj1"+i);
      try{
        suran1.getLocalInterface().write(oid, 0, b.length, b, false);
      }catch(IOException e){
        e.printStackTrace();
      }
    }
    
    SecureCore sc = (SecureCore)suran1.getCore();
    sc.securityFilter.getBranchManager().createNewBranch((BranchID)nid1, 5);
        
    
   rmiregistry.destroy();
    
    try{
      Thread.sleep(5000);
    }catch(InterruptedException e1){

    }
    */
  }
//  public void testURANode2(){
//
//    //if(SangminConfig.forkjoin) return;
//    Process rmiregistry = null;
//    try{
//      rmiregistry = Runtime.getRuntime().exec("rmiregistry");
//    }catch(IOException e1){
//      // TODO Auto-generated catch block
//      e1.printStackTrace();
//      fail();
//    }    
//    try{
//      Thread.sleep(1000);
//    }catch(InterruptedException e1){      
//    }
//
// 
//    byte[] b = new byte[10];
//    for(int i=0; i < b.length; i++){
//      b[i] = 40;
//    }
//    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");
//    SubscriptionSetFilter ssf = new SubscriptionSetFilter(ss);
//    LinkedList<Filter> f = new LinkedList<Filter>();
//    f.add(ssf);
//
//    BranchID nid1 = new BranchID(10);
//    LivenessFilter lf = new TrustedServerBlockingLivenessFilter(nid1);
//    SecureURANode suran1 = new SecureURANode(configpath, nid1,
//        code.Controller.NULL_CONTROLLER,true,true,lf,f);
//
//    for(int i=0; i < 10; i++){     
//      ObjId oid = new ObjId("/obj1"+i);
//      try{
//        suran1.getLocalInterface().write(oid, 0, b.length, b, false);
//      }catch(IOException e){
//        e.printStackTrace();
//      }
//    }    
//
//    BranchID nid1_partner = new BranchID(11);
//    lf = new TrustedServerBlockingLivenessFilter(nid1_partner);
//    SecureURANode suran1_partner = new SecureURANode(configpath, nid1_partner,
//        code.Controller.NULL_CONTROLLER,true,true,lf,f);
//
//
//    try{
//      suran1_partner.getRMIClientInterface().subscribeInval(nid1, nid1_partner,
//          ss, AcceptVV.makeVVAllNegatives(), true);
//    }catch(RMINetworkException e){
//      e.printStackTrace();
//      fail();
//    }catch(RMIApplicationException e){
//      e.printStackTrace();
//      fail();
//    }
//
//    try{
//      Thread.sleep(5000);
//    }catch(InterruptedException e1){
//
//    }
//    
//    for(int i=0; i < 10; i++){
//      ObjId oid = new ObjId("/obj1"+i);
//
//      try{      
//        BodyMsg bd = suran1_partner.getLocalInterface().read(oid, 0, b.length, false, false, 10000);
//        if(bd == null) assert false; // TIMEOUT!
//      }catch(EOFException e){
//        e.printStackTrace();
//        fail();
//      }catch(ObjNotFoundException e){
//        System.out.println("Failed to find obj : " + oid);
//        e.printStackTrace();
//        fail();
//      }catch(IOException e){
//        e.printStackTrace();
//        fail();
//      }catch(ReadOfInvalidRangeException e){      
//
//      }catch(ReadOfHoleException e){
//        e.printStackTrace();
//        fail();
//      }
//    }
//    try{
//      suran1_partner.getRMIClientInterface().removeSubscribeInval(nid1, nid1_partner, ss);
//    }catch(RMINetworkException e2){
//      e2.printStackTrace();
//      fail();
//    }catch(RMIApplicationException e2){
//      e2.printStackTrace();
//      fail();
//    }
//    
//    
//    suran1.shutdown();
//
//    lf = new TrustedServerBlockingLivenessFilter(nid1);
//    SecureURANode suran2 = new SecureURANode(configpath, nid1,
//        code.Controller.NULL_CONTROLLER, true, true, lf, f);
//
//    for(int i=0; i < 10; i++){
//      ObjId oid;
//      if(i<5)
//        oid = new ObjId("/obj1"+i);
//      else
//        oid = new ObjId("/obj2"+i);
//
//      try{
//        suran2.getLocalInterface().write(oid, 0, b.length, b, false);
//      }catch(IOException e){
//        e.printStackTrace();
//        fail();
//      }
//    }    
//
//    BranchID nid2_partner = new BranchID(13);
//    lf = new TrustedServerBlockingLivenessFilter(nid2_partner);
//    SecureURANode suran2_partner = new SecureURANode(configpath, nid2_partner,
//        code.Controller.NULL_CONTROLLER,true,true,lf,f);
//
//    try{
//      suran2_partner.getRMIClientInterface().subscribeInval(nid1, nid2_partner,
//          ss, AcceptVV.makeVVAllNegatives(), true);
//    }catch(RMINetworkException e){
//      e.printStackTrace();
//      fail();
//    }catch(RMIApplicationException e){
//      e.printStackTrace();
//      fail();
//    }
//    
//    try{
//      Thread.sleep(5000);
//    }catch(InterruptedException e1){
//
//    }
//    
//    for(int i=0; i < 10; i++){
//      ObjId oid;
//      if(i<5)
//        oid = new ObjId("/obj1"+i);
//      else
//        oid = new ObjId("/obj2"+i);
//
//      try{      
//        BodyMsg bd = suran2_partner.getLocalInterface().read(oid, 0, b.length, false, false, 1000);
//        if(bd == null) assert false; // TIMEOUT!
//      }catch(EOFException e){
//        e.printStackTrace();
//        fail();
//      }catch(ObjNotFoundException e){        
//        e.printStackTrace();
//        fail();
//      }catch(IOException e){
//        e.printStackTrace();
//        fail();
//      }catch(ReadOfInvalidRangeException e){      
//
//      }catch(ReadOfHoleException e){
//        e.printStackTrace();
//        fail();
//      }
//    }
//    suran2.shutdown();
//    
//    BranchID nid_merged = new BranchID(14);
//    lf = new TrustedServerBlockingLivenessFilter(nid_merged);
//    SecureURANode suran_merged = new SecureURANode(configpath, nid_merged,
//        code.Controller.NULL_CONTROLLER,true,true,lf,f);
//    System.out.println("First Sync");
//    try{
//      suran_merged.getRMIClientInterface().subscribeInval(nid1_partner, nid_merged,
//          ss, AcceptVV.makeVVAllNegatives(), true);
//    }catch(RMINetworkException e){
//      e.printStackTrace();
//      fail();
//    }catch(RMIApplicationException e){
//      e.printStackTrace();
//      fail();
//    }
//    
//    try{
//      Thread.sleep(5000);
//    }catch(InterruptedException e1){
//
//    }
//    System.out.println("Second Sync");
//    try{
//      suran_merged.getRMIClientInterface().subscribeInval(nid2_partner, nid_merged,
//          ss, AcceptVV.makeVVAllNegatives(), true);
//    }catch(RMINetworkException e){
//      e.printStackTrace();
//      fail();
//    }catch(RMIApplicationException e){
//      e.printStackTrace();
//      fail();
//    }
//    
//    try{
//      Thread.sleep(5000);
//    }catch(InterruptedException e1){
//
//    }
//    
//    rmiregistry.destroy();
//    
//    try{
//      Thread.sleep(5000);
//    }catch(InterruptedException e1){
//
//    }
//  }

//  public void testCehckCompatibility(){
//    ForkableAHSMap ahs = new ForkableAHSMap();
//    BranchKnowledge knowledge = new BranchKnowledge();
//    BranchManager bm = new BranchManager(knowledge, ahs);
//    for(SecurePreciseInv spi : invals_b0_0to19){
//      try{
//        ahs.applySecurePreciseInv(spi);        
//        knowledge.applyInval(spi, new Hash(ahs.getHash(spi.getCreator()), false));        
//      }catch(UnmatchingTreeNodeException e){
//        fail();
//      }
//    }
//    BranchID bid = (BranchID)invals_b0_0to19.get(0).getNodeId();
//    Segment seg0_4 = new Segment(0,4,bid, new Hash(ahs.asAHS(bid, 4).getHash(), false),true);
//    Segment seg0_7 = new Segment(0,7,bid, new Hash(ahs.asAHS(bid, 7).getHash(), false),true);
//    try{
//      assert bm.checkCompatibility(seg0_4, seg0_7) == null;
//    }catch(ConflictingSegmentsException e){
//      assert false;
//    }
//
//  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(BranchManagerUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "BranchManagerUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}
