package code.branchDetecting.unit;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.tree.TreeNode;

import code.AcceptStamp;
import code.AcceptVV;
import code.Config;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.SummaryHash;
import code.branchDetecting.BranchID;
import code.branchDetecting.ConflictingSegmentsException;
import code.branchDetecting.ForkableAHSMap;
import code.branchDetecting.Segment;
import code.security.DataHash;
import code.security.SecurePreciseInv;
import code.security.SecureURANode;
import code.security.ahs.DependencyVV;
import code.security.ahs.RootList;
import code.security.ahs.UnmatchingTreeNodeException;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ForkableAHSMapUnit extends TestCase{

  private Vector<SecurePreciseInv> invals_b0_0to19 = new Vector<SecurePreciseInv>();


  protected void setUp() throws Exception{
    super.setUp();

    PrivateKey privKey;
    PublicKey pubKey;
    NodeId nodeId;

    byte[] hash = new byte[]{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
    nodeId = new BranchID(10);

    byte[] buffer;
    byte[] buffer2;
    Config.readKeys();
    privKey = (PrivateKey)Config.privateKeys.get(new Long(nodeId.getIDint()));
    pubKey = (PublicKey)Config.publicKeys.get(new Long(nodeId.getIDint()));

    buffer = new byte[]{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
    buffer2 = new byte[]{10,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,19};

    SummaryHash sh = new SummaryHash();
    sh.putValue(buffer);
    DataHash dh = new DataHash();
    dh.putHashVal(buffer2);

    for(int i=0; i < 10; i++){
      DependencyVV dvv = new DependencyVV();
      dvv.put(nodeId, i-1);

      SecurePreciseInv spi =
        new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand0/"+i), 5, 10) ,
            new AcceptStamp(i, nodeId),
            new AcceptStamp(i, nodeId),
            false, dvv, sh, dh, privKey);

      invals_b0_0to19.add(spi);
      //ahsMap.applySecurePreciseInv(spi);
      //copyAHSMap.applySecurePreciseInv(spi);
      //FilterKnowledge fk = ahsMap.getKnowledge().getFilterKnowledge(f);
      //assert fk.getCVV().includes(spi.getAcceptStamp()): fk;
      //assert !fk.getHoles().containsKey(nodeId) || fk.getHoles().get(nodeId).isEmpty(): fk;
    }
    NodeId nodeId2 = new BranchID(20);
    NodeId lastUpdateNode = nodeId;
    NodeId id = nodeId;
    for(int i=10; i < 20; i++){
      DependencyVV dvv = new DependencyVV();
      dvv.put(lastUpdateNode, i-1);
      if(i%2 == 0)
        id = nodeId;
      else
        id = nodeId2;
      lastUpdateNode = id;
      SecurePreciseInv spi =
        new SecurePreciseInv(new ObjInvalTarget(new ObjId("/rand0/"+i), 5, 10) ,
            new AcceptStamp(i, id),
            new AcceptStamp(i, id),
            false, dvv, sh, dh, privKey);

      invals_b0_0to19.add(spi);
    }
  }

  public void testCreateNewBranch(){
    ForkableAHSMap ahs = new ForkableAHSMap();

    for(SecurePreciseInv spi : invals_b0_0to19){
      try{
        ahs.applySecurePreciseInv(spi);
      }catch(UnmatchingTreeNodeException e){
        fail();
      }

    }
    BranchID bid = (BranchID)invals_b0_0to19.get(0).getNodeId();
    assert ahs.getSummaryHashAfter(bid, 5).equals(ahs.getSummaryHashAtOrBefore(bid, 6));

    ahs.createNewBranch(bid, 16);
    assert ahs.getTreeNodeTS(bid, 16) == null && ahs.getTreeNodeTS(bid, 14) != null;
    ahs.createNewBranch(bid, 12);
    assert ahs.getTreeNodeTS(bid, 12) == null && ahs.getTreeNodeTS(bid, 10) != null;;
    ahs.createNewBranch(bid, 5);
    assert ahs.getTreeNodeTS(bid, 5) == null && ahs.getTreeNodeTS(bid, 4) != null;;
    AcceptVV vv = ahs.getCurrentVV();
    // Must have 5 elements after creating 3 branches.. originally we had 2
    assert vv.size() == 5;
    Iterator<AcceptStamp> i = vv.getAllStamps().iterator();
    while(i.hasNext()){
      long ts = i.next().getLocalClock();
      assert ts == 4 || ts == 10 || ts == 14 || ts == 18 || ts==19;
    }
    
    
    
    System.out.println(ahs.toLongString());

  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(ForkableAHSMapUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "ForkableAHSMapUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}
