package code.branchDetecting.unit;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

import code.AcceptStamp;
import code.Config;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.SummaryHash;
import code.branchDetecting.*;
import code.security.DataHash;
import code.simulator.IrisNode;
import code.simulator.NodeFactory;
import code.simulator.SecureSimPreciseInv;
import code.security.ahs.DependencyVV;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import code.simulator.*;
import code.simulator.log.Log;
import code.simulator.log.NodeLog;
import code.security.SangminConfig;

public class LogBranchDetectorUnit extends TestCase{

  public static int UNIT_NODE_ID = 10;
  public static int MIDDLE_NODE_ID = 15;

  public static int HELPER_NODE_ID = 20;
  public static boolean vverbose = false;
  public static boolean verbose = true;
  IrisNode myNode;
  IrisNode myNodeForkA;
  IrisNode myNodeForkB;
  IrisNode myNodeForkC;
  IrisNode myNodeForkD;
  IrisNode myNodeForkAA;

  protected void setUp() throws Exception{
    super.setUp();
    SangminConfig.useSimulatorId = false;
    
  }

  protected void populate() throws Exception{
    System.out.println("testForking");
    BranchID nodeId = new BranchID(UNIT_NODE_ID);
    myNode = (IrisNode)NodeFactory.createIrisNode(nodeId);
    byte[] buffer = new byte[]{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
    byte[] buffer2 = new byte[]{1,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};

    if(vverbose){
      System.out.println("UNIT ID: " + nodeId.toString());
    }
    
    write(myNode, "/rand0/", 0, 9, 0);
    checkRead(myNode, "/rand0/", 0, 9, 0);

    LinkedList<Node> forkedNodes = myNode.fork(3);
    
    myNodeForkA = (IrisNode)forkedNodes.get(0);
    myNodeForkB = (IrisNode)forkedNodes.get(1);

    myNodeForkC = (IrisNode)NodeFactory.createIrisNode(new BranchID(UNIT_NODE_ID, 10, new Hash(buffer, false)));
    myNodeForkC.sync(myNode);
    
    myNodeForkD = (IrisNode)NodeFactory.createIrisNode(new BranchID(UNIT_NODE_ID, 10, new Hash(buffer2, false)));
    myNodeForkD.sync(myNode);
    
    write(myNodeForkA, "/rand0a/", 0, 9, 10);
    checkRead(myNodeForkA, "/rand0a/", 0, 9, 10);
    write(myNodeForkB, "/rand0b/", 0, 9, 20);
    checkRead(myNodeForkB, "/rand0b/", 0, 9, 20);

    write(myNodeForkC, "/rand0c/", 0, 9, 30);
    checkRead(myNodeForkC, "/rand0c/", 0, 9, 30);

    LinkedList<Node> forkedNodes2 = myNodeForkA.fork(2);
    myNodeForkAA = (IrisNode)forkedNodes2.get(0);
    
  }
  
  
  protected void tearDown() throws Exception{
    super.tearDown();
  }
  
  public void testDetectBranches(){
    System.exit(-1);
//    populate();
//    BranchKnowledge Strbk1 = this.myNodeForkC.getLog().getKnowledge();
//    BranchKnowledge Strbk2 = this.myNodeForkD.getLog().getKnowledge();
//    
//    BranchDetector bd = new BranchDetector(this.myNodeForkC.getLog());
//
//    bd.registerReceiverSegementChecker(this.myNodeForkD.getLog());
//    
//    bd.detectBranches();
//    
//    BranchKnowledge bk1 = this.myNodeForkC.getLog().getKnowledge();
//    BranchKnowledge bk2 = this.myNodeForkD.getLog().getKnowledge();
//    
//    assert Strbk1.equals(bk1) &&
//    Strbk2.equals(bk2) 
//    : "*** Before comparison\n" + "###TESTNODE 1###\n" + Strbk1 +"\n"
//    + "###TESTNODE 2###\n" + Strbk2 + "\n*** After comparison\n"
//    + "###TESTNODE 1###\n" + bk1.toString()+"\n"
//    + "###TESTNODE 2###\n" +bk2.toString()+"\n" ;

  }

  public void testDetectBranches2(){
    System.exit(-1);
    /*
     * tn1 has single branch
     * tn2 has forked branches which are not compatible with t1's
     * i.e tn1 has a longer segment
     */
//    System.out.println("testDetectBranch2");
//    populate();
//    BranchKnowledge Strbk1 = this.myNodeForkC.getLog().getKnowledge();
//    BranchKnowledge Strbk2 = this.myNodeForkA.getLog().getKnowledge();
//    
//    BranchDetector bd = new BranchDetector(this.myNodeForkC.getLog());
//
//    bd.registerReceiverSegementChecker(this.myNodeForkA.getLog());
//    
//    bd.detectBranches();
//    
//    BranchKnowledge bk1 = this.myNodeForkC.getLog().getKnowledge();
//    BranchKnowledge bk2 = this.myNodeForkA.getLog().getKnowledge();
//  
//    assert Strbk1.equals(bk1);
//    
//    // For tn1, the split segments must start at -1 and 10 
//    SegmentGroups sgs = bk2.getSegmentGroups(new BranchID(10));
//    assert sgs != null;
//    Iterator<SegmentGroup> itr = sgs.getIterator();
//    SegmentGroup sg = itr.next();
//    if (sg.getStartTS() != -1){      
//      fail(sg.toString());      
//    }
//    assert sg.getSegments().size() == 1;
//    Iterator<Segment> iterSeg = sg.getSegments().iterator();
//    Segment s = iterSeg.next();
//    assert s.getStartTS() == 0 && !s.isLeaf() && s.getEndTS() == 9;
//    
//    sg = itr.next();
//    if (sg.getStartTS() != 10){
//      fail(sg.toString());      
//    }
//    assert sg.getSegments().size() == 1;
//    iterSeg = sg.getSegments().iterator();
//    s = iterSeg.next();
//    assert s.getStartTS() == 10 && s.isLeaf() && s.getEndTS() == 19;
//    
//    Log log = this.myNodeForkA.getLog();
//    assert log.keySet().size() == 2;
//    for(NodeId nid :  log.keySet()){
//      BranchID bid = (BranchID)nid;
//      NodeLog nl = log.get(bid);
//      if(bid.equals(myNodeForkA.getBranchID())){
//        assert nl.get(9).getAcceptStamp().getLocalClock() == 9;
//      } else {
//        assert nl.get(0).getAcceptStamp().getLocalClock() == 10;
//      }
//    }   
//    
  }
  
  public void testDetectBranches3(){
    System.exit(-1);
//    /*
//     * Scenario
//     * Node tn1 and tn2 have forked log of Node 10 at time stamp 10
//     * But tn1 and tn2 don't know about the forking point
//     * (i.e. they are common until time stamp 9)
//     */
//    System.out.println("testDetectBranch3");
//    populate();
//    BranchKnowledge Strbk1 = this.myNodeForkA.getLog().getKnowledge();
//    BranchKnowledge Strbk2 = this.myNodeForkB.getLog().getKnowledge();
//    
//    BranchDetector bd = new BranchDetector(this.myNodeForkA.getLog());
//
//    bd.registerReceiverSegementChecker(this.myNodeForkB.getLog());
//    
//    bd.detectBranches();
//    
//    BranchKnowledge bk1 = this.myNodeForkA.getLog().getKnowledge();
//    BranchKnowledge bk2 = this.myNodeForkB.getLog().getKnowledge();
//    
//    assert !Strbk1.equals(bk1);
//    assert !Strbk2.equals(bk2);
//    
//    // Check if BK is modified correctly
//    SegmentGroups sgs = bk2.getSegmentGroups(new BranchID(10));
//    assert sgs != null;
//    Iterator<SegmentGroup> itr = sgs.getIterator();
//    SegmentGroup sg = itr.next();
//    if (sg.getStartTS() != -1){      
//      fail(sg.toString());      
//    }
//    assert sg.getSegments().size() == 1;
//    Iterator<Segment> iterSeg = sg.getSegments().iterator();
//    Segment s = iterSeg.next();
//    assert s.getStartTS() == 0 && !s.isLeaf() && s.getEndTS() == 9;
//    
//    sg = itr.next();
//    if (sg.getStartTS() != 10){
//      fail(sg.toString());      
//    }
//    assert sg.getSegments().size() == 1;
//    iterSeg = sg.getSegments().iterator();
//    s = iterSeg.next();
//    assert s.getStartTS() == 10 && s.isLeaf() && s.getEndTS() == 19;
//    //------------
//    sgs = bk1.getSegmentGroups(new BranchID(10));
//    assert sgs != null;
//    itr = sgs.getIterator();
//    sg = itr.next();
//    if (sg.getStartTS() != -1){      
//      fail(sg.toString());      
//    }
//    assert sg.getSegments().size() == 1;
//    iterSeg = sg.getSegments().iterator();
//    s = iterSeg.next();
//    assert s.getStartTS() == 0 && !s.isLeaf() && s.getEndTS() == 9;
//    
//    sg = itr.next();
//    if (sg.getStartTS() != 10){
//      fail(sg.toString());      
//    }
//    assert sg.getSegments().size() == 1;
//    iterSeg = sg.getSegments().iterator();
//    s = iterSeg.next();
//    assert s.getStartTS() == 10 && s.isLeaf() && s.getEndTS() == 19;
//    
//    //--------
//    
//    // Check Log
//    Log log = this.myNodeForkA.getLog();
//    assert log.keySet().size() == 2;
//    for(NodeId nid :  log.keySet()){
//      BranchID bid = (BranchID)nid;
//      NodeLog nl = log.get(bid);
//      if(bid.equals(myNodeForkA.getBranchID())){
//        assert nl.get(9).getAcceptStamp().getLocalClock() == 9;
//      } else {
//        assert nl.get(0).getAcceptStamp().getLocalClock() == 10;
//      }
//    }
//    
//    //-----
//    log = this.myNodeForkB.getLog();
//    assert log.keySet().size() == 2;
//    for(NodeId nid :  log.keySet()){
//      BranchID bid = (BranchID)nid;
//      NodeLog nl = log.get(bid);
//      if(bid.equals(myNodeForkB.getBranchID())){
//        assert nl.get(9).getAcceptStamp().getLocalClock() == 9;
//      } else {
//        assert nl.get(0).getAcceptStamp().getLocalClock() == 10;
//      }
//    }        
  }
  
//  public void testDetectBranches4(){
//    /*
//     * Scenario
//     * Node tn1 and tn2 have forked log of Node 10 at time stamp 10
//     * But tn1 and tn2 don't know about the forking point
//     * (i.e. they are common until time stamp 9)
//     */
//    System.out.println("testDetectBranch4");
//    TestNode tn1 = new TestNode();
//    TestNode tn2 = new TestNode();
//  
//    for(int i=0; i < 10; i++){
//      SecureSimPreciseInv spi = invals_b0_0to9.get(i);
//      tn1.applyInval(spi);
//      tn2.applyInval(spi);
//    }
//    
//    for(int i=0; i < 10; i++){
//      SecureSimPreciseInv spi = invals_b0_10to19_a.get(i);
//      tn1.applyInval(spi);
//      spi = invals_b0_10to19_b.get(i);
//      tn2.applyInval(spi);
//    }
//    
//    System.out.println("*** Before comparison");
//    System.out.println("###TESTNODE 1###\n" + tn1.getBranchKnowledge().toString());
//    System.out.println("###TESTNODE 2###\n" +tn2.getBranchKnowledge().toString());
//    
//    tn1.getBranchDetector().registerReceiverSegementChecker(tn2.getSegmentCheckInterface());
//    tn1.getBranchDetector().detectBranches();
//    
//    // For tn1, the split segments must start at -1 and 10 
//    SegmentGroups sgs = tn1.getBranchKnowledge().getSegmentGroups(new BranchID(10));
//    assert sgs != null;
//    Iterator<SegmentGroup> itr = sgs.getIterator();
//    SegmentGroup sg = itr.next();
//    if (sg.getStartTS() != -1){      
//      fail(sg.toString());      
//    }
//    sg = itr.next();
//    if (sg.getStartTS() != 10){
//      fail(sg.toString());      
//    }
//    // For tn1, the split segments must start at -1 and 10 
//    sgs = tn2.getBranchKnowledge().getSegmentGroups(new BranchID(10));
//    assert sgs != null;
//    itr = sgs.getIterator();
//    sg = itr.next();
//    if (sg.getStartTS() != -1){      
//      fail(sg.toString());      
//    }
//    sg = itr.next();
//    if (sg.getStartTS() != 10){
//      fail(sg.toString());      
//    }
//    System.out.println("*** After comparison");
//    System.out.println("###TESTNODE 1###\n" + tn1.getBranchKnowledge().toString());
//    System.out.println("###TESTNODE 2###\n" +tn2.getBranchKnowledge().toString());
//    
//    
//  }
  
  public static void checkRead(IrisNode n, 
      String prefix, 
      int is, int ie, int startVal){
      int ii;

    if(vverbose){
      System.out.println("Reading initial data: " + is + " to " + ie + " etc.");
    }
    for(ii = is; ii <= ie; ii++){

      ObjId oid = new ObjId(prefix + "/" + ii );
      if(vverbose){
        System.out.println("Reading " + oid);
      }
      assert n.read(oid).equals(startVal + ii): "Expected value for obj " + oid + " was " + (startVal + ii) + " instead found " + n.read(oid);
    }
  }

 /** 
 *  Write -- write 1-byte items to /prefix/[is..ie]/[js..je]/[ks..ke].
 
 *  Return final accept stamp.
 
 **/ 
  public static void write(IrisNode n, 
                           String prefix, 
                           int is, int ie, 
                           int startVal){
    int ii;

    if(vverbose){
      System.out.println("Writing initial data: " + is + " to " + ie + " etc.");
    }
    for(ii = is; ii <= ie; ii++){

      ObjId oid = new ObjId(prefix + "/" + ii );
      if(vverbose){
        System.out.println("Writing " + oid);
      }
     
      n.write(oid, new IrisDataObject(new Integer(startVal + ii)));
    }
  }
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(LogBranchDetectorUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "BranchDetectorUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }
}
