 /** 
/* BayouNode
 *
 * Encapsulates BayouFS, BayouFSLocalInterface, and a URAOverlogNode
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.util.*;
import java.io.*;

public class BayouNode {
  private URAOverlogNode bayouOverlogNode;
  private BayouFSLocalInterface bayouFSLocalInterface;
  private BayouFS bayouFS;

 /** 
 *  Constructor 
 **/ 
 public BayouNode(String configPath,
		   String p2ConfigPath,
		   NodeId myNodeId,
		   boolean cleanDb,
		   String overlogPath,
		   String nodeMapPath){
   this(configPath, p2ConfigPath, myNodeId, cleanDb, overlogPath, nodeMapPath, true);
 }


  public BayouNode(String configPath,
		   String p2ConfigPath,
		   NodeId myNodeId,
		   boolean cleanDb,
		   String overlogPath,
		   String nodeMapPath,
                   boolean makeRoot){
    
    bayouOverlogNode = new URAOverlogNode(configPath,
					  p2ConfigPath,
					  myNodeId,
					  cleanDb,
					  overlogPath,
					  nodeMapPath,
					  false);
    bayouFSLocalInterface = new BayouFSLocalInterface(bayouOverlogNode.getLocalInterface(),
						      myNodeId);
    bayouFS =  new BayouFS(bayouFSLocalInterface, makeRoot);
  }

 /** 
 *  Start the node 
 **/ 

  public void start() throws Exception {
    bayouOverlogNode.start();
  }

 /** 
 *  Start the node 
 **/ 

  public void start(boolean noOverlog) throws Exception {
    bayouOverlogNode.start(noOverlog);
  }


 /** 
 *  shutdown the node 
 **/ 

  public void shutdown() throws Exception {
    bayouOverlogNode.shutdown();
  }


 /** 
 *  returns the FSLocalInterface 
 **/ 
  public BayouFSLocalInterface getFSInterface(){
    return bayouFSLocalInterface;
  }


 /** 
 *  returns the FS 
 **/ 
  public BayouFS getFS(){
    return bayouFS;
  }


  public static void main(String args[]) {
    if (args.length < 6 ) {
      System.out.println("Usage: BayouNode configfile p2configfile nodeId cleanDb overlogfile nodemapfile");
      return;
    }
    
    BayouNode node = new BayouNode(args[0],
                                   args[1],
                                   new NodeId(new Long(args[2]).longValue()),
                                   new Boolean(args[3]).booleanValue(),
                                   args[4],
                                   args[5]);
    try{
      node.start();
      System.out.println("Bayou Node started");
      node.userInterface(System.in, node.bayouFSLocalInterface);
    }catch(Exception e) {
      e.printStackTrace();
    }
  }

 /** 
 *  register handler -- used by experiments 
 **/ 
  public void registerHandler(TupleHandler th) {
    bayouOverlogNode.registerHandler(th);
  }


 /** 
 *  insert tuple - used by experiments 
 **/ 
  public void insertTuple(Tuple tp){
    bayouOverlogNode.insertTuple(tp);
  }


 /** 
 *  UserInterface -- for testing purposes 
 **/ 
 
  public void userInterface(InputStream is, PRACTIFSLocalInterface li){
    
    boolean dbg = true;
    long accumulatedTimeMillis = 0;
    long nextWriteExpectedTime = System.currentTimeMillis();
    long startTime = System.currentTimeMillis();
    long writeNum = 0;

    System.out.println("Enter action:  ");
    System.out.println("Comments       : c [comments]");
    System.out.println("Write          : w [ObjId] [String]");
    System.out.println("Read           : r [ObjId] [String]");
    System.out.println("End            : e");
    
    BufferedReader din = null;
		
    try{
      din = new BufferedReader(new InputStreamReader(is));
		
      System.out.print("Enter command: ");
      String input;
      for(input = din.readLine(); input!= null; input=din.readLine()) {
        
	
        byte[] action = input.getBytes();
		
        if(action[0] == 'w'){
          writeNum++;
          StringTokenizer st = new StringTokenizer(input.substring(2));
          ObjId objId = new ObjId(st.nextToken());
          String str = "";
	  while(st.hasMoreElements()){
	    str = str+st.nextToken();
	    str += " ";
	  }
	  str.trim();
         

	  try{
	    Env.dprintln(dbg, "Writing obj:" + objId);
	    li.write(objId, 0, str.length(), str.getBytes());
	  }catch(Exception e){
	    e.printStackTrace();
	    //continue
	  }
		    
        } else if (action[0] == 'r'){
	  StringTokenizer st = new StringTokenizer(input.substring(2));
          ObjId objId = new ObjId(st.nextToken());
          String str = "";
	  
          try{
	    Env.dprintln(dbg, "Reading obj:" + objId);
	    BodyMsg bm = li.read(objId, 0, 10000);
	    str = bm.getBody().toString();
	    System.out.println(str);
          }catch(Exception e){
            //
            // ObjNotFoundException or EOFException
            //
	    e.printStackTrace();
	    //continue;
          }
                    
        } else if (action[0] == 'e'){
          System.exit(-1);

       
        } else if (action[0] == 'c'){
          // Do nothing
        } 
	System.out.print("Enter command: ");
      }//for
    } catch (Exception e){
      e.printStackTrace();
      System.out.println("Wrong input format ...");
    }	
  }
}
 /** 
/* $Log: BayouNode.java,v $
/* Revision 1.7  2007/11/07 00:45:02  nalini
/* bayou example updated
/*
/* Revision 1.6  2007/03/14 00:55:33  nalini
/* updated constructor
/*
/* Revision 1.5  2007/02/28 03:26:07  nalini
/* added paramter not to start overlog
/*
/* Revision 1.4  2007/02/21 01:50:53  nalini
/* Bayou Exp 1 added
/*
/* Revision 1.3  2007/02/12 06:19:49  zjiandan
/* Expose noSyncLog parameter, add more unittest for PRACTIFS, PangaeaFS.
/*
/* Revision 1.2  2007/01/15 20:26:05  nalini
/* Bayou and NFS works
/*
/* Revision 1.1  2007/01/12 19:09:32  nalini
/* Bayou case-study created
/*
 */
 **/ 
