 /** 
/*  Bayou_Exp1_Node1.java
 * 
 *  Bayou case study experiment 1
 *
 *  Purpose: to find anti-entropy execution times vs number of writes
 *  propagated
 * 
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;

public class Bayou_Exp1_Node1 {

  private BayouNode node1;
  private BayouFSLocalInterface node1_interface;
  
  public static long NODE_1_ID = 0;
  public static long NODE_2_ID = 1;
  public static String CONFIG_PATH = "Bayou_Exp1.config";
  public static String CONFIG_P2_PATH = "Bayou_Exp1.p2config";
  public static String NODEID_MAP_PATH = "Bayou_Exp1.nodemap";
  public static String OVERLOG_PATH = "Bayou_Exp1.olg";

  private long numMessages;
  private long size;
  private static String node1Hostname = "localhost";
  private static String node2Hostname = "localhost";

  private boolean helperStarted = false;
  private boolean helperEnded = false;

  private boolean dbg = true;

 /** 
 *  Constructor 
 **/ 

  public Bayou_Exp1_Node1(long numMessages,
                    long size,
                    String node1Hostname,
                    String node2Hostname){

    this.numMessages = numMessages;
    this.size = size;
    this.node1Hostname = node1Hostname;
    this.node2Hostname = node2Hostname;

   
    makePractiConfig(node1Hostname,node2Hostname,CONFIG_PATH);
    makeP2Config(CONFIG_P2_PATH);
    makeNodeIdMap(node1Hostname, node2Hostname, NODEID_MAP_PATH);
    
    node1 = new BayouNode(CONFIG_PATH, 
			  CONFIG_P2_PATH,
			  new NodeId(NODE_1_ID),
			  true,
			  OVERLOG_PATH,
			  NODEID_MAP_PATH);

    node1_interface = node1.getFSInterface();
    
    TupleHandler th = new AliveTupleHandler(this);
    node1.registerHandler(th);
    th = new ExpFinishedTupleHandler(this);
    node1.registerHandler(th);

  }

 /** 
 *  Make configuration 
 **/ 
    public static void makePractiConfig(String node1name, String node2name, String configPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(NODE_1_ID),
                            node1name,
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                           "Bayou_Exp1_Test-" + 
			    NODE_1_ID + ".db",
                            "/*",
                            -1L,
                            node1name,
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
    Config.addOneNodeConfig(new NodeId(NODE_2_ID),
			   node2name,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "Bayou_Exp1_Test-" + 
			   NODE_2_ID+".db",
			   "/*",
			   -1L,
			   node2name,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   Config.writeToFile(configPath);
  }

 public static void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(NODE_1_ID), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(NODE_2_ID), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

    public static void makeNodeIdMap(String node1name, String node2name, String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(NODE_1_ID), new OverlogId(node1name+":5000"));
    NodeIdMap.add(new NodeId(NODE_2_ID), new OverlogId(node2name+":5001"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }


//---------------------------------------------------------------------------
//  Starts the Overlog 
//---------------------------------------------------------------------------
   
  public synchronized void startNode() throws Exception{
    node1.start();
    wait(2000);
  }

//---------------------------------------------------------------------------
// shutdown
//---------------------------------------------------------------------------
   
  public synchronized void shutdown() throws Exception{
    node1.shutdown();
  }
  
//---------------------------------------------------------------------------
// Waits until helper is started.
//---------------------------------------------------------------------------
   
  public synchronized void waitForHelperStart(){
 
    while(!helperStarted){
      String[] stringA = {"areYouAlive", 
                          NodeIdMap.getOverlogId(new NodeId(NODE_1_ID)).toString(),
                          NodeIdMap.getOverlogId(new NodeId(NODE_2_ID)).toString()};
      Tuple t = new Tuple(stringA);
      node1.insertTuple(t);
      try{
        wait(2000);
      }catch(InterruptedException e) {
        // do nothing and continue
      }
    }
  }


//---------------------------------------------------------------------------
// Waits until helper ends.
//---------------------------------------------------------------------------
   
  public synchronized void waitForHelperEnd(){
 
    while(!helperEnded){
      try{
        wait();
      }catch(InterruptedException e) {
        // do nothing and continue
      }
    }
  }

//---------------------------------------------------------------------------
// notified by tuplehandler when helper has started
//---------------------------------------------------------------------------
 
  public synchronized void helperStarted(){
    helperStarted = true;
    notifyAll();
  }
    

//---------------------------------------------------------------------------
// notified by tuplehandler when helper has started
//---------------------------------------------------------------------------
 
  public synchronized void helperEnded(){
    helperEnded = true;
    notifyAll();
  }

//---------------------------------------------------------------------------
//  Converts values to byte arrays
//---------------------------------------------------------------------------

  private byte[] convertToArray(byte value){
    byte[] b = new byte[(int)size];
    for(int i = 0; i < size; i++) {
      b[i] = value;
    }
    return b;
  }


//---------------------------------------------------------------------------
//  Writes a value to the specified interfac
//---------------------------------------------------------------------------

  private void write(ObjId objId, byte[] b)
    throws IOException{
    node1_interface.write(objId, 0, size, b);
  }


//---------------------------------------------------------------------------
// Start test
//---------------------------------------------------------------------------
  public  void startTest() {
    try{
      // wait for helper to start
      System.out.println("Waiting for helper to start");
      waitForHelperStart();
      
      //Helper started, carry out writes
      System.out.println("Writing objs");
      byte[] b = convertToArray((byte) 65);
      for(int i=0; i<numMessages; i++){
        ObjId objId = new ObjId("/" + i);
        write(objId, b);
      }
      
    //Finished Writes
      System.out.println("Finished Writes");
      String[] stringA = {"finishedWrites", 
                          NodeIdMap.getOverlogId(new NodeId(NODE_1_ID)).toString(),
                          NodeIdMap.getOverlogId(new NodeId(NODE_2_ID)).toString()};
      Tuple t = new Tuple(stringA);
      node1.insertTuple(t);
      
      // wait for helper to end
      waitForHelperEnd();
    }catch(Exception e) {
      e.printStackTrace();
    }
  }

//---------------------------------------------------------------------------
// main method
//---------------------------------------------------------------------------

  public static void main(String[] args) {

    if (args.length < 4) {
      System.out.println("Usage: Bayou_Exp1_Node1 <numMessages> <sizeOfMessages> " +
                         "<node1hostname> <node2hostname>");
      
      return;
    }

    Bayou_Exp1_Node1 exp = new Bayou_Exp1_Node1((new Long(args[0])).longValue(), 
                                    (new Long(args[1])).longValue(),
                                    args[2],
                                    args[3]);

    try{
      exp.startNode();
      exp.startTest();
      exp.shutdown();
    }catch(Exception e) {
      e.printStackTrace();
    }
    System.out.println("Test Ended"); 
    System.exit(0);
          
  }

//---------------------------------------------------------------------------
// AliveTupleHandler -- watches yesAlive tuple
//---------------------------------------------------------------------------

  class AliveTupleHandler extends TupleHandler {
    private Bayou_Exp1_Node1 test;

    public AliveTupleHandler(Bayou_Exp1_Node1 test) {
      super("yesAlive");
      this.test = test;
    }

    public void handleTuple(Tuple tp) {
      test.helperStarted();
    }
  }

//---------------------------------------------------------------------------
// ExpFinishedTupleHandler -- watches expFinished handler
//---------------------------------------------------------------------------

   class ExpFinishedTupleHandler extends TupleHandler {
     private Bayou_Exp1_Node1 test;
     
     public ExpFinishedTupleHandler(Bayou_Exp1_Node1 test) {
       super("expFinished");
       this.test = test;
     }

     public void handleTuple(Tuple tp) {
       test.helperEnded();
     }
   }
}
    
//---------------------------------------------------------------------------
/* $Log: Bayou_Exp1_Node1.java,v $
/* Revision 1.8  2007/03/09 03:01:39  nalini
/* removed update workers option from P2Config
/*
/* Revision 1.7  2007/02/27 04:50:10  nalini
/* minor updates
/*
/* Revision 1.6  2007/02/27 00:16:38  nalini
/* *** empty log message ***
/*
/* Revision 1.5  2007/02/26 23:57:26  nalini
/* *** empty log message ***
/*
/* Revision 1.4  2007/02/26 23:55:19  nalini
/* *** empty log message ***
/*
/* Revision 1.3  2007/02/26 23:25:21  nalini
/* porting exp 1 code to FC
/*
/* Revision 1.2  2007/02/26 22:21:33  nalini
/* bayou exp 1
/*
/* Revision 1.1  2007/02/21 17:04:49  nalini
/* minor updates
/*
/*
*/
 /** 
