 /** 
/*  Bayou_Exp1_Node2.java
 * 
 *  Bayou case study experiment 1
 *
 *  assumes that node 1 has already been started
 *
 *  Purpose: to find anti-entropy execution times vs number of writes
 *  propagated
 * 
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;

public class Bayou_Exp1_Node2 {
 
  private BayouNode node2;
  private BayouFSLocalInterface node2_interface;

  private long numMessages;
  private long size;
  private String outFile;

  private static String node1Hostname = "localhost";
  private static String node2Hostname = "localhost";

  
  private String entropyStart;
  private String entropyEnd;
  private boolean finishedMeasuring = false;

    private boolean dbg = false;
  
 /** 
 *  Constructor 
 **/ 

  public Bayou_Exp1_Node2(long numMessages,
			  long size,
			  String outFile,
			  String node1Hostname,
			  String node2Hostname){
    this.numMessages = numMessages;
    this.size = size;
    this.outFile = outFile;
    this.node1Hostname = node1Hostname;
    this.node2Hostname = node2Hostname;

    
    Bayou_Exp1_Node1.makePractiConfig(node1Hostname, node2Hostname, Bayou_Exp1_Node1.CONFIG_PATH);
    Bayou_Exp1_Node1.makeP2Config(Bayou_Exp1_Node1.CONFIG_P2_PATH);
    Bayou_Exp1_Node1.makeNodeIdMap(node1Hostname, node2Hostname,Bayou_Exp1_Node1.NODEID_MAP_PATH);

    node2 = new BayouNode(Bayou_Exp1_Node1.CONFIG_PATH, 
			  Bayou_Exp1_Node1.CONFIG_P2_PATH,
			  new NodeId(Bayou_Exp1_Node1.NODE_2_ID),
			  true,
			  Bayou_Exp1_Node1.OVERLOG_PATH,
			  Bayou_Exp1_Node1.NODEID_MAP_PATH);

    node2_interface = node2.getFSInterface();

    TupleHandler th = new EntropyStartTupleHandler(this);
    node2.registerHandler(th);
    th = new EntropyEndTupleHandler(this);
    node2.registerHandler(th);
  }

 /** 
 *   Starts the Overlog  
 **/ 
   
  public synchronized void startNode() throws Exception{
    node2.start();
    wait(2000);
  }

 /** 
 *  shutdown 
 **/ 
   
  public synchronized void shutdown() throws Exception{
    node2.shutdown();
  }
  

 /** 
 *   print results 
 **/ 
 
 public synchronized void printResults() {
    try{
      PrintStream out = new PrintStream(new FileOutputStream(outFile, true));
      long entropyDuration = parseTime(entropyEnd) - parseTime(entropyStart);

      //out.println(numMessages + "\t" + size + "\t" + entropyStart + "\t" + entropyEnd +
      //           "\t" + parseTime(entropyStart) + "\t" + parseTime(entropyEnd));
 
      out.println(numMessages + "\t" + size + "\t" + entropyDuration);
      out.close();
    }catch(Exception e) {
      e.printStackTrace();
    }
  }

 /** 
 *  entropyStart 
 **/ 
  public synchronized void entropyStart(String time){
    Env.dprintln(dbg, "EntropySTart = " + parseTime(time));
    entropyStart = time;
  }

 /** 
 *  entropyEnd 
 **/ 
   public synchronized void entropyEnd(String time){
    entropyEnd = time;
    finishedMeasuring = true;
    System.out.println("entropyEnd called");
    Env.dprintln(dbg, "EntropyEnd = " + parseTime(time));
    notifyAll();
  }


 /** 
 *  Parse time -- converts from P2 format to ms 
 *  Example Input String: [2007-Feb-20 20:03:57.445064000]  
 **/ 
  public synchronized long parseTime(String time) {
    long ret = 0;
    
    // skip over date
    int i = time.indexOf(' ');
    String tmpString = time.substring(i+1);
    
    // handle hour
    i = tmpString.indexOf(':');
    long value = (new Long(tmpString.substring(0,i))).longValue();
    ret+= value;
    tmpString = tmpString.substring(i+1);

    //handle minute
    i = tmpString.indexOf(':');
    value = (new Long(tmpString.substring(0,i))).longValue();
    ret = ret*60 + value;
    tmpString = tmpString.substring(i+1);

    //handle second
    i = tmpString.indexOf('.');
    value = (new Long(tmpString.substring(0,i))).longValue();
    ret = ret*60 + value;
    tmpString = tmpString.substring(i+1);

    //handle milliseconds
     value = (new Long(tmpString.substring(0,3))).longValue();
     ret = ret*1000 + value;

     return ret;
  }

    
    
 /** 
 *  startTest 
 **/ 
  public synchronized void startTest() {
    // do nothing until we receive "entropyEnd"
    while(!finishedMeasuring){
      try{
        wait();
      }catch(InterruptedException e) {
        // do nothing
      }
    }

    System.out.println("Received Entropy End.. printing results");
    //print results
    printResults();    

    //insert a finished measuring tuple
    String[] stringA = {"finishedMeasuring", 
                        NodeIdMap.getOverlogId(new NodeId(Bayou_Exp1_Node1.NODE_2_ID)).toString(),
                        NodeIdMap.getOverlogId(new NodeId(Bayou_Exp1_Node1.NODE_1_ID)).toString()};
    Tuple t = new Tuple(stringA);
    node2.insertTuple(t);
    try{
      wait(100); // wait for the tuple to go across the line
    } catch(InterruptedException e) {
      // do nothing
    }
  }



 /** 
 *  main Method 
 **/ 
  public static void main(String[] args) {
    if(args.length < 5) {
      System.out.println("Usage: Bayou_Exp1_Node2 <numMessage> <size> <outFile> <node1name> <node2name>");
      return;
    }

    Bayou_Exp1_Node2 exp = new Bayou_Exp1_Node2((new Long(args[0])).longValue(), 
                                     (new Long(args[1])).longValue(),
						args[2],
						args[3], 
						args[4]);

    try{
      exp.startNode();
      exp.startTest();
      exp.shutdown();
    }catch(Exception e) {
      e.printStackTrace();
    }

    System.out.println("Test Ended");
    System.exit(0);
  }
    
 /** 
 *   Entropy Start Tuple Handler 
 **/ 
  class EntropyStartTupleHandler extends TupleHandler {
    private Bayou_Exp1_Node2 test;
    
    public EntropyStartTupleHandler(Bayou_Exp1_Node2 test) {
      super("entropyStart");
      this.test = test;
    }

    public void handleTuple(Tuple tp){
      test.entropyStart(tp.getItem(2));
    }
  }
 
 /** 
 *  Entropy End Tuple Handler 
 **/ 

  class EntropyEndTupleHandler extends TupleHandler {
    private Bayou_Exp1_Node2 test;
    
    public EntropyEndTupleHandler(Bayou_Exp1_Node2 test) {
      super("entropyEnd");
      this.test = test;
    }

    public void handleTuple(Tuple tp){
      test.entropyEnd(tp.getItem(2));
    }
  }
 
}

 /** 
/* $Log: Bayou_Exp1_Node2.java,v $
/* Revision 1.6  2007/02/27 02:53:11  nalini
/* *** empty log message ***
/*
/* Revision 1.5  2007/02/27 02:49:10  nalini
/* bugfixes
/*
/* Revision 1.4  2007/02/27 00:16:38  nalini
/* *** empty log message ***
/*
/* Revision 1.3  2007/02/26 23:55:19  nalini
/* *** empty log message ***
/*
/* Revision 1.2  2007/02/26 22:21:33  nalini
/* bayou exp 1
/*
/* Revision 1.1  2007/02/21 17:04:49  nalini
/* minor updates
/*
/*
*/
 **/ 
