set title "Anti-Entropy Time vs Number of Writes"
set xlabel "Number of Writes"
set ylabel "Execution time(ms)"
set xrange [0:500]

plot	"Exp1_100_combinedResults.txt" using 1:2 title '100 byte writes' lt 3 pt 1, \
	"Exp1_100_combinedResults.txt" using 1:3 notitle lt 3 pt 1, \
	"Exp1_100_combinedResults.txt" using 1:4 notitle lt 3 pt 1, \
	"Exp1_100_combinedResults.txt" using 1:5 notitle lt 3 pt 1, \
	"Exp1_100_combinedResults.txt" using 1:6 notitle lt 3 pt 1, \
 "Exp1_100_combinedResults.txt" using 1:($2+$3+$4+$5+$6)/5 with linespoints title '100 byte writes average' lt 1, \
	"Exp1_3K_combinedResults.txt" using 1:2 title '3000 byte writes' lt 4 pt 2, \
	"Exp1_3K_combinedResults.txt" using 1:3 notitle lt 4 pt 2, \
	"Exp1_3K_combinedResults.txt" using 1:4 notitle lt 4 pt 2, \
	"Exp1_3K_combinedResults.txt" using 1:5 notitle lt 4 pt 2, \
	"Exp1_3K_combinedResults.txt" using 1:6 notitle lt 4 pt 2, \
 "Exp1_3K_combinedResults.txt" using 1:($2+$3+$4+$5+$6)/5 with linespoints title '3000 byte writes average' lt -1

set size 1.0,0.6
set terminal postscript eps portrait color lw 1 "Helvetica" 14
set output "Anti-Entropy.ps"
replot    
set terminal x11     
set size 1,1