#! /lusr/bin/sh


if [ $# -ne 5 ]; then
    echo "Usage: runExpInstance.sh <numMessages> <size> <outFile> <node1hostname> <node2hostname>"
    exit 127
fi

practiDir=/home/nalini/research/universalReplication/code
expDir=$practiDir/case-studies/Bayou/experiments/exp1
user=nalini

echo $expDir

numMessages=$1
size=$2
outFile=$3
localhostname=$4
remotehostname=$5


#start node 1
echo "Starting Node 1"
ssh  $localhostname sh $expDir/runNode.sh 1 $numMessages $size $outFile $localhostname $remotehostname 2>&1 | tee node1.out &
sleep 2 
#start node 2
echo "Starting Node 2"
ssh $remotehostname sh $expDir/runNode.sh 2 $numMessages $size $outFile $localhostname $remotehostname 2>&1 | tee node2.out &


ret=1
iter=0
#check if finished
while [ 1 ];
do 
  echo "in runExpInstance while loop iter= $iter"
  sleep 10
  iter=`expr $iter + 1`
  #check success of first node first node
  ended=`tail node1.out| grep "Test Ended" | wc -l`
  if [ $ended -gt 0 ]; then
      ret=0
      break
  fi
  #check if node 1 failed due to jvm crash
  failed=`cat node1.out | grep "error" | wc -l`
  if [ $failed -gt 0 ]; then
      ret=1
      break
  fi

 #check if node 1 failed due to rmiregistry
  failed=`cat node1.out | grep "remake rmic" | wc -l`
  if [ $failed -gt 0 ]; then
      ret=1
      break
  fi
  
  #check if node 1 failed - due to p2 problem
  failed=`cat node1.out | grep "failed" | wc -l`
  if [ $failed -gt 0 ]; then
      ret=1
      break
  fi

 #check if node 2 failed
  failed=`cat node2.out | grep "error" | wc -l`
  if [ $failed -gt 0 ]; then
      ret=1
      break
  fi

 #check if node 2 failed
  failed=`cat node2.out | grep "remake rmic" | wc -l`
  if [ $failed -gt 0 ]; then
      ret=1
      break
  fi

  #check if node 2 failed - due to p2 problem
  failed=`cat node2.out | grep "failed" | wc -l`
  if [ $failed -gt 0 ]; then
      ret=1
      break
  fi
  # maybe it hanged for more than 5 min no apparent reason
  if [ $iter -gt 30 ]; then
      ret=1
      break
  fi
done  
  

#cleaning up
ssh $localhostname pkill -u $user java
ssh $remotehostname pkill -u $user java
pkill -u nalini rsh

exit $ret