#! /bin/sh

if [ $# -ne 6 ]; then
    echo "Usage: runNode.sh <node=1/2> <numMessages> <size> <outFile> <node1hostname> <node2hostname>"
    exit 127
fi

practiDir=/home/nalini/research/universalReplication/code
expDir=$practiDir/case-studies/Bayou/experiments/exp1/
javaBin=/usr/java/jdk1.5.0_07/bin

node=$1
numMessages=$2
size=$3
outFile=$4
localhostname=$5
remotehostname=$6


echo "kill rmi registry"
# Kill "rmiregistry" and wait for it to finish
kill `ps aux |grep -v grep | grep "rmiregistry" | awk '{print$2}'`
sleep 2


#set up the environment
cd $practiDir
source setenv-FC.sh

#restart the rmi registry
echo "restarting registry"
cd classes
$javaBin/rmiregistry &
sleep 5


echo "Starting Node for experiment"
#start the test
cd $expDir
if [ "$node" == 1 ]; then
    $javaBin/java Bayou_Exp1_Node1 $numMessages $size $localhostname $remotehostname
else
    $javaBin/java Bayou_Exp1_Node2 $numMessages $size $outFile $localhostname $remotehostname
fi

#cleanup
echo "cleanup"
rm -f hs*.log

# Kill "rmiregistry" and wait for it to finish
kill `ps aux |grep -v grep | grep "rmiregistry" | awk '{print$2}'`
sleep 2

