 /** 
/*  Bayou_Exp2_Node1.java
 * 
 *  Bayou case study experiment 2
 *
 *  opens the pre-populated DB
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;

public class Bayou_Exp2_Node1 {

  private BayouNode node1;
  private BayouFSLocalInterface node1_interface;
  
  public static long NODE_1_ID = 0;
  public static long NODE_2_ID = 1;
  public static String CONFIG_PATH = "Bayou_Exp2.config";
  public static String CONFIG_P2_PATH = "Bayou_Exp2.p2config";
  public static String NODEID_MAP_PATH = "Bayou_Exp2.nodemap";
  public static String OVERLOG_PATH = "Bayou_Exp2.olg";

  private static String dbPathSuffix = "PopulatedDb";
  private static String node1Hostname = "localhost";
  private static String node2Hostname = "localhost";


  private boolean expFinished=false;
  private boolean dbg = true;

 /** 
 *  Constructor 
 **/ 


  public Bayou_Exp2_Node1 (String dbPath, String node1Hostname, String node2Hostname) {
    this.dbPathSuffix = dbPath;
    this.node1Hostname = node1Hostname;
    this.node2Hostname = node2Hostname;

    makePractiConfig(node1Hostname, node2Hostname, CONFIG_PATH);
    makeP2Config(CONFIG_P2_PATH);
    makeNodeIdMap(node1Hostname, node2Hostname, NODEID_MAP_PATH);
    
    node1 = new BayouNode(CONFIG_PATH, 
			  CONFIG_P2_PATH,
			  new NodeId(NODE_1_ID),
			  false,  //cleanDB=false
			  OVERLOG_PATH,
			  NODEID_MAP_PATH);

    node1_interface = node1.getFSInterface();
    TupleHandler th = new ExpFinishedTupleHandler(this);
    node1.registerHandler(th);
  }

 /** 
 *  Make configuration 
 **/ 
  public static void makePractiConfig(String node1host, String node2host,String configPath) {
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(NODE_1_ID),
                            node1host,
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            dbPathSuffix+".db",
                            "/*",
                            -1L,
                            node2host,
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);

    Config.addOneNodeConfig(new NodeId(NODE_2_ID),
			   node2host,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "Bayou_Exp2_Test-" + 
			   NODE_2_ID+".db",
			   "/*",
			   -1L,
			   node2host,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    Config.writeToFile(configPath);
  }

 public static void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(NODE_1_ID), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(NODE_2_ID), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

public static void makeNodeIdMap(String node1host, String node2host, String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(NODE_1_ID), new OverlogId(node1host+":5000"));
    NodeIdMap.add(new NodeId(NODE_2_ID), new OverlogId(node2host+":5001"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }

//---------------------------------------------------------------------------
//  Starts the Overlog 
//---------------------------------------------------------------------------
   
  public synchronized void startNode() throws Exception{
    node1.start();
    wait(2000);
  }

//---------------------------------------------------------------------------
// shutdown
//---------------------------------------------------------------------------
   
  public synchronized void shutdown() throws Exception{
    node1.shutdown();
  }
 

//---------------------------------------------------------------------------
// Reads an object from the specified interface
// If objNotFound -- sleeps for some time and tries again
//---------------------------------------------------------------------------

  public synchronized ImmutableBytes read(ObjId objId, int size) throws Exception {
    ImmutableBytes b=null;;
    try{
      while (true) {
	try{
	  b = node1_interface.read(objId, 0, size).getBody();
	  break;
	}catch(ObjNotFoundException e){
	  //wait until you recieve obj
	  Env.dprintln(dbg, "ObjNotFoundException for " + objId);
	  Thread.currentThread().sleep(50);
	}
      }
    }catch(Exception e) {
      e.printStackTrace();
      assert(false);
    }
    return b;
  }

//---------------------------------------------------------------------------
// test read
//---------------------------------------------------------------------------
   
  public synchronized void testRead() throws Exception{
//    System.out.println("Trying to read /10/1/0");
//    read(new ObjId("/10/1/0"), 10);
//    System.out.println("Trying to read /100/1/0");
//    read(new ObjId("/100/1/0"), 100);
    System.out.println("Trying to read /1000/1/0");
    read(new ObjId("/1000/1/0"), 1000);
//    System.out.println("Trying to read /10000/1/0");
//    read(new ObjId("/10000/1/0"), 1000);
//    System.out.println("Trying to read /100000/1/0");
//    read(new ObjId("/100000/1/0"), 10000);
    System.out.println("Finished Reading");

  }
  

//---------------------------------------------------------------------------
// notified by tuplehandler when exp has finished
//---------------------------------------------------------------------------
 
  public synchronized void expFinished(){
    expFinished = true;
    notifyAll();
  }

//---------------------------------------------------------------------------
// Waits until helper ends.
//---------------------------------------------------------------------------
   
  public synchronized void waitForExpEnd(){
 
    while(!expFinished){
      try{
        wait();
      }catch(InterruptedException e) {
        // do nothing and continue
      }
    }
  }

//---------------------------------------------------------------------------
// startTest
//---------------------------------------------------------------------------
  public synchronized void startTest(){
    // do nothing until we receive an expEnded tuple
    waitForExpEnd();
  }

//---------------------------------------------------------------------------
// main method
//---------------------------------------------------------------------------

  public static void main(String[] args) {

    if (args.length < 3) {
      System.out.println("Usage: Bayou_Exp2_Node1 <dbPathSuffix> <host1name> <host2name>");
      return;
    }

    Bayou_Exp2_Node1 exp = new Bayou_Exp2_Node1(args[0], args[1], args[2]);

    try{ 
      exp.startNode();
      //exp.testRead();
      exp.startTest();
      exp.shutdown();
    }catch(Exception e) {
      e.printStackTrace();
    }
    System.out.println("Test Ended");
    System.exit(0);
  }

//---------------------------------------------------------------------------
// ExpFinishedTupleHandler -- watches expFinished handler
//---------------------------------------------------------------------------

   class ExpFinishedTupleHandler extends TupleHandler {
     private Bayou_Exp2_Node1 test;
     
     public ExpFinishedTupleHandler(Bayou_Exp2_Node1 test) {
       super("expFinished");
       this.test = test;
     }

     public void handleTuple(Tuple tp) {
       test.expFinished();
     }
   }
}

//---------------------------------------------------------------------------
/* $Log: Bayou_Exp2_Node1.java,v $
/* Revision 1.2  2007/03/09 03:01:39  nalini
/* removed update workers option from P2Config
/*
/* Revision 1.1  2007/02/28 03:24:45  nalini
/* bayou exp2 added
/*
*/
 /** 
