#! /bin/sh


if [ $# -ne 5 ]; then
    echo "Usage: runExpInstance.sh  <type=1/2> <dbPath> <node1hostname> <node2hostname> <outFile>"
    exit 127
fi

practiDir=/home/nalini/research/universalReplication/code
expDir=$practiDir/case-studies/Bayou/experiments/exp2
user=nalini

echo $expDir

type=$1
dbPath=$2
node1hostname=$3
node2hostname=$4
outFile=$5


#start node 1
echo "Starting Node 1"
ssh  $node1hostname /bin/sh $expDir/runNode.sh 1 $type $dbPath $node1hostname $node2hostname $outFile 2>&1 | tee node1.out &
sleep 5 
#start node 2
echo "Starting Node 2"
ssh $node2hostname /bin/sh $expDir/runNode.sh 2  $type $dbPath $node1hostname $node2hostname $outFile 2>&1 | tee node2.out &


ret=1
iter=0
#check if finished
while [ 1 ];
do 
  echo "in runExpInstance while loop iter= $iter"
  sleep 60
  iter=`expr $iter + 1`
  #check success of first node first node
  ended=`tail node1.out| grep "Test Ended" | wc -l`
  if [ $ended -gt 0 ]; then
      ret=0
      break
  fi
  #check if node 1 failed due to jvm crash
  failed=`cat node1.out | grep "error" | wc -l`
  if [ $failed -gt 0 ]; then
      ret=1
      break
  fi

 #check if node 1 failed due to rmiregistry
  failed=`cat node1.out | grep "remake rmic" | wc -l`
  if [ $failed -gt 0 ]; then
      ret=1
      break
  fi
  
  #check if node 1 failed - due to p2 problem
  failed=`cat node1.out | grep "failed" | wc -l`
  if [ $failed -gt 0 ]; then
      ret=1
      break
  fi

 #check if node 2 failed
  failed=`cat node2.out | grep "error" | wc -l`
  if [ $failed -gt 0 ]; then
      ret=1
      break
  fi

 #check if node 2 failed
  failed=`cat node2.out | grep "remake rmic" | wc -l`
  if [ $failed -gt 0 ]; then
      ret=1
      break
  fi

  #check if node 2 failed - due to p2 problem
  failed=`cat node2.out | grep "failed" | wc -l`
  if [ $failed -gt 0 ]; then
      ret=1
      break
  fi
  # maybe it hanged for more than 15 min no apparent reason
  if [ $iter -gt 15 ]; then
      ret=1
      break
  fi
done  
  

#cleaning up
ssh $node1hostname pkill -u $user java
ssh $node2hostname pkill -u $user java

exit $ret