#! /bin/sh

if [ $# -ne 6 ]; then
    echo "Usage: runNode.sh <node=1/2> <type=1/2> <dbPath> <node1hostname> <node2hostname> <outFile>"
    exit 127
fi

practiDir=/home/nalini/research/universalReplication/code
expDir=$practiDir/case-studies/Bayou/experiments/exp2/
javaBin=/usr/java/jdk1.5.0_07/bin

node=$1
type=$2
dbPath=$3
node1hostname=$4
node2hostname=$5
outFile=$6

echo "kill rmi registry"
# Kill "rmiregistry" and wait for it to finish
kill `ps aux |grep -v grep | grep "rmiregistry" | awk '{print$2}'`
sleep 2


#set up the environment
cd $practiDir
source setenv-FC.sh

#restart the rmi registry
echo "restarting registry"
cd classes
$javaBin/rmiregistry &
sleep 5


echo "Starting Node for experiment"
#start the test
cd $expDir
if [ "$node" == 1 ]; then
    $javaBin/java Bayou_Exp2_Node1 $dbPath $node1hostname $node2hostname
else
    $javaBin/java Bayou_Exp2_Node2 $type $dbPath $node1hostname $node2hostname $outFile
fi

#cleanup
echo "cleanup"
rm -f hs*.log

# Kill "rmiregistry" and wait for it to finish
kill `ps aux |grep -v grep | grep "rmiregistry" | awk '{print$2}'`
sleep 2

