set title "Anti-Entropy Bandwidth vs Number of Writes"
set xlabel "Number of Writes"
set ylabel "Number of kilo bytes transfered"
set xrange [0:500]
set yrange[0:1600]

plot "exp3_100_full.txt" using 1:($2/1000) with linespoints title '100-byte writes - full', \
    "exp3_100_small.txt" using 1:($2/1000) with linespoints title '100-byte writes - small', \
    "exp3_ideal.txt" using 1:($2/1000) with linespoints title '100-byte writes - ideal', \
    "exp3_3000_full.txt" using 1:($2/1000) with linespoints title '3K-byte writes - full', \
    "exp3_3000_small.txt" using 1:($2/1000) with linespoints title '3K-byte writes - small', \
    "exp3_ideal.txt" using 1:($3/1000) with linespoints title '3K-byte writes - ideal'

set size 1.0,0.6
set terminal postscript eps portrait color lw 1 "Helvetica" 14
set output "Anti-Entropy-Bandwidth.ps"
replot    
set terminal x11     
set size 1,1