 /** 
/*  Bayou_LocalTest.java
 * 
 *  To find the time it takes to make writes
 * 
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;

public class Bayou_LocalTest {

  private BayouNode node1;
  private BayouFSLocalInterface node1_interface;
  
  private long numMessages;
  private long size;
  private String outFile;

  private long writeStart=0;
  private long writeEnd=0;

  public static String CONFIG_PATH = "Bayou_Local.config";
  public static String CONFIG_P2_PATH = "Bayou_Local.p2config";
  public static String NODEID_MAP_PATH = "Bayou_Local.nodemap";
  public static String OVERLOG_PATH = "Garbage.olg"; 

 /** 
 *  Constructor 
 **/ 

  public Bayou_LocalTest(long numMessages,
			 long size,
			 String outFile){

    this.numMessages = numMessages;
    this.size = size;
    this.outFile = outFile;

    makePractiConfig(CONFIG_PATH);
    makeP2Config(CONFIG_P2_PATH);
    makeNodeIdMap(NODEID_MAP_PATH);
    
    node1 = new BayouNode(CONFIG_PATH, 
			  CONFIG_P2_PATH,
			  new NodeId(0),
			  true,
			  OVERLOG_PATH,
			  NODEID_MAP_PATH);

    node1_interface = node1.getFSInterface();
    
  }

 /** 
 *  Make configuration 
 **/ 
  private static void makePractiConfig(String configPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(0),
                            "localhost",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                           "Bayou_Local_Test-0.db",
                            "/*",
                            -1L,
			    "localhost",
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
    Config.writeToFile(configPath);

  }

 private static void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(0), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  private static void makeNodeIdMap(String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(0), new OverlogId("localhost:5000"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }


//---------------------------------------------------------------------------
//  Starts the Overlog 
//---------------------------------------------------------------------------
   
  public synchronized void startNode() throws Exception{
    node1.start();
    wait(2000);
  }

//---------------------------------------------------------------------------
// shutdown
//---------------------------------------------------------------------------
   
  public synchronized void shutdown() throws Exception{
    node1.shutdown();
  }
  
//---------------------------------------------------------------------------
//  print results
//---------------------------------------------------------------------------
 
 public synchronized void printResults() {
    try{
      PrintStream out = new PrintStream(new FileOutputStream(outFile, true));
      
      long writeDuration = writeEnd - writeStart;
 
      out.println(numMessages + "\t" + size + "\t" + writeDuration);
      out.close();
    }catch(Exception e) {
      e.printStackTrace();
    }
  }


//---------------------------------------------------------------------------
//  Converts values to byte arrays
//---------------------------------------------------------------------------

  private byte[] convertToArray(byte value){
    byte[] b = new byte[(int)size];
    for(int i = 0; i < size; i++) {
      b[i] = value;
    }
    return b;
  }


//---------------------------------------------------------------------------
//  Writes a value to the specified interfac
//---------------------------------------------------------------------------

  private void write(ObjId objId, byte[] b)
    throws IOException{
    node1_interface.write(objId, 0, size, b);
  }


//---------------------------------------------------------------------------
// Start test
//---------------------------------------------------------------------------
  public  void startTest() {
    try{

      
      //Helper started, carry out writes
      System.out.println("Writing objs");
      byte[] b = convertToArray((byte) 65);
      
      writeStart=System.currentTimeMillis();
      for(int i=0; i<numMessages; i++){
        ObjId objId = new ObjId("/" + i);
        write(objId, b);
      }
      writeEnd=System.currentTimeMillis();
      
      //Finished Writes
      System.out.println("Finished Writes");
      
      printResults();
    
    }catch(Exception e) {
      e.printStackTrace();
    }
  }

//---------------------------------------------------------------------------
// main method
//---------------------------------------------------------------------------

  public static void main(String[] args) {

    if (args.length < 3) {
      System.out.println("Usage: Bayou_LocalTest <numMessages> <sizeOfMessages> " +
                         "<outputfile>");
      
      return;
    }

    Bayou_LocalTest exp = new Bayou_LocalTest((new Long(args[0])).longValue(), 
					      (new Long(args[1])).longValue(),
					      args[2]);

    try{
      exp.startNode();
      exp.startTest();
      exp.shutdown();
    }catch(Exception e) {
      e.printStackTrace();
    }
    System.out.println("Test Ended"); 
    System.exit(0);
          
  }
}
    
//---------------------------------------------------------------------------
/* $Log: Bayou_LocalTest.java,v $
/* Revision 1.2  2007/03/09 03:01:39  nalini
/* removed update workers option from P2Config
/*
/* Revision 1.1  2007/02/26 22:18:20  nalini
/* Bayou local write test
/*
*/
 /** 
