 /** 
/* ChainReplicationFSRMIServer.java
 *
 *  RMIServer for ChainReplicationFS so that the reads can be
 *  redirected to the tail and the writes can be 
 *  redirected to the head.
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 


import java.rmi.*;
import java.io.*;

public interface ChainReplicationFSRMIServer extends java.rmi.Remote {

 /** 
 *  read 
 **/ 
  public BodyMsg read(ObjId objId, long offset, long length)
    throws java.rmi.RemoteException, ObjNotFoundException, 
	   EOFException, IOException, ReadOfHoleException;

 /** 
 *  write 
 **/ 
  public long write(ObjId objId, long offset, long length, byte buffer[])
    throws java.rmi.RemoteException, IOException;


 /** 
 *  writeMulti 
 **/ 
  public long[] write(FSWriteEntry[] fwe)
    throws java.rmi.RemoteException, IOException;
}

 /** 
/* $Log: ChainReplicationFSRMIServer.java,v $
/* Revision 1.2  2007/02/27 04:44:41  zjiandan
/* change readOfHole interface such that read of hole will throw an
/* ReadOfHoleException with the position of the next written byte.
/*
/* Revision 1.1  2007/01/18 23:47:13  nalini
/* chain replication case study added
/*
*/
 **/ 
