 /** 
 *  Implement an InputStream interface to a PRACTI object.   
 *    
 *   All "read" method calls are changed to "readLocal" 
 *  
 *  Note: This class is not thread safe! 
 **/ 
import java.io.StreamCorruptedException;
import java.io.IOException;
import java.io.EOFException;
import java.io.InputStream;
import java.io.FileNotFoundException;

public class ChainReplicationFileInputStream extends PRACTIFileInputStream {
  private boolean dbg = false;

 /** 
 *  Constructor 
 **/ 
  public
  ChainReplicationFileInputStream(ChainReplicationFSLocalInterface newLocalInterface,
                        ObjId newObjId,
                        int newBlockSize)
    throws IOException{
    super(newLocalInterface, newObjId, newBlockSize);
  }
    
  void iniRead() throws IOException {
    try{
     BodyMsg  bodyMsg = ((ChainReplicationFSLocalInterface)super.localInterface).readLocal(super.objId,
                                               0,
                                               super.blockSize);
      
      super.ib = bodyMsg.getBody();
      super.objOffset += super.ib.getLength();
    }catch(EOFException eofe){
      // Note that we want to allow an application to create a
      // PRACTIFileInputStream object even for an object that is empty. So,
      // the constructor should not throw an EOFException. The read methods,
      // on the other hand, will throw EOFException if an applcation tries to
      // read a non-zero number of bytes from an empty object.
      this.ib = new ImmutableBytes(new byte[0]);
    }catch(ReadOfHoleException rhe){
      //same as EOFException
      this.ib = new ImmutableBytes(new byte[0]);


    }catch(ObjNotFoundException onfe){
      
      // Convert this to an exception that is thrown by InputStream
      throw new FileNotFoundException("" + onfe);
    }
    Env.dprintln(DEBUG, "ib=" + ib);
  }

 /** 
 *  Read a byte of data 
 **/ 
  public int
  read() throws
    StreamCorruptedException,
    EOFException,
    IOException,
    FileNotFoundException{

    Env.dprintln(DEBUG, "ChainRepFileInputStream: read invoked");

    BodyMsg bodyMsg = null;
    byte[] data = null;
    int val = 0;

    if(super.ib == null){
      throw new StreamCorruptedException("Stream for " + super.objId +
                                         " closed");
    }
    while(super.ibOffset >= super.ib.getLength()){
      try{
        // The while loops keeps reading until we receive a non-zero number
        // of bytes
        bodyMsg = ((ChainReplicationFSLocalInterface)super.localInterface).readLocal(super.objId,
                                                super.objOffset,
                                                super.blockSize);
        super.ib = bodyMsg.getBody();
        super.objOffset += super.ib.getLength();
        super.ibOffset = 0;

      }catch(ObjNotFoundException onfe){
        // Convert this to an exception that is thrown by InputStream
        throw new FileNotFoundException("" + onfe);
      }catch(ReadOfHoleException rhe){
	assert false;//assume that this File InputStream is only used for read meta data
	//which is well defined and never has a hole
      }
    }
    data = super.ib.dangerousGetReferenceToInternalByteArray();
    // Cut off the series of 1's that appear because of sign-extensions during
    // typecasting a byte to an int
    val = ((int)data[super.ibOffset]) & 0xFF;
    super.ibOffset++;
    return(val);
  }

 /** 
 *  Populate the array of bytes with data and return the number of bytes 
 *  read 
 **/ 
  public int
  read(byte[] b, int off, int len) throws
    StreamCorruptedException,
    EOFException,
    IOException,
    FileNotFoundException{
    Env.dprintln(DEBUG, "ChainRepFileInputStream: read invoked");

    BodyMsg bodyMsg = null;
    byte[] data = null;
    int numBytesToCopy = 0;

    assert(b.length >= len);
    if(super.ib == null){
      throw new StreamCorruptedException("Stream for " + super.objId +
                                         " closed");
    }
    while(super.ibOffset >= super.ib.getLength()){
      try{
        // The while loop keeps reading until we receive a non-zero number
        // of bytes
        bodyMsg =((ChainReplicationFSLocalInterface)super.localInterface).readLocal(super.objId,
                                                super.objOffset,
                                                super.blockSize);
        super.ib = bodyMsg.getBody();
        super.objOffset += super.ib.getLength();
        super.ibOffset = 0;
      }catch(ObjNotFoundException onfe){
        // Convert this to an exception that is thrown by InputStream
        throw new FileNotFoundException("" + onfe);
      }
      catch(ReadOfHoleException rhe){
	assert false;//assume that this File InputStream is only used for read meta data
	//which is well defined and never has a hole
      }
      
    }
    numBytesToCopy = (super.ib.getLength() - super.ibOffset);
    if(numBytesToCopy > len){
      numBytesToCopy = len;
    }
    data = super.ib.dangerousGetReferenceToInternalByteArray();
    System.arraycopy(data, super.ibOffset, b, off, numBytesToCopy);
    super.ibOffset += numBytesToCopy;
    return(numBytesToCopy);
  }

}