 /** 
/* ChainReplicationHeadTupleHandler.java
 * 
 * Handler for currHead Tuple
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

public class ChainReplicationHeadTupleHandler extends TupleHandler {
  
  private ChainReplicationFSLocalInterface fsLi;
  
  private boolean dbg = false;

  public ChainReplicationHeadTupleHandler(ChainReplicationFSLocalInterface fsLi) {
   super("head");
   this.fsLi = fsLi; 
  }
  
  public void handleTuple(Tuple tp) 
    throws MalformedTupleException {
    Env.dprintln(dbg, "ChainReplicationHeadTupleHandler: " + tp);
    // <head, myOverlogId, volId,  headOverlogId, P>
    String volId = tp.getItem(2);
    NodeId headNodeId = NodeIdMap.getNodeId(new OverlogId(tp.getItem(3)));
    fsLi.recvHead(volId, headNodeId);
  }

}

 /** 
/* $Log: ChainReplicationHeadTupleHandler.java,v $
/* Revision 1.2  2007/03/11 21:19:55  nalini
/* chain replication consistency and volume revamped
/*
/* Revision 1.1  2007/01/18 23:47:14  nalini
/* chain replication case study added
/*
*/
 **/ 
