 /** 
/* ChainReplicationNode
 *
 * Encapsulates ChainReplicationFS, ChainReplicationFSLocalInterface, and a URAOverlogNode
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 


public class ChainReplicationNode {
  private URAOverlogNode chainReplicationOverlogNode;
  private ChainReplicationFSLocalInterface chainReplicationFSLocalInterface;
  private ChainReplicationFS chainReplicationFS;
  private ChainReplicationFSRMIServerImpl chainReplicationFSRMIServerImpl;

  private boolean nfs = false;  // whether this node was initiated thro
                                // the NFS interface.
  private boolean disableVol = false; //whether we should disable volumes

 /** 
 *  Constructor 
 **/ 
  public ChainReplicationNode(String configPath,
                              String p2ConfigPath,
                              NodeId myNodeId,
                              boolean cleanDb,
                              String overlogPath,
                              String nodeMapPath,
                              boolean nfs,
                              boolean disableVol){

    
    chainReplicationOverlogNode = new URAOverlogNode(configPath,
                                                     p2ConfigPath,
                                                     myNodeId,
                                                     cleanDb,
                                                     overlogPath,
                                                     nodeMapPath, 
						     false);
    //chainReplicationOverlogNode.getP2Runtime().getCore().setCatchupTypeToCP(true);
    assert false: "add CP to all subscribeInval tuple in ChainReplication.olg";
    this.nfs = nfs;
    this.disableVol = disableVol;
    SyncMailBox syncBox = new SyncMailBox();

   try{
      chainReplicationFSRMIServerImpl = new ChainReplicationFSRMIServerImpl(chainReplicationOverlogNode.getLocalInterface(), 
                                                                            myNodeId,
                                                                            syncBox, 
                                                                            nfs,
                                                                            disableVol);
    }catch(Exception e) {
      assert(false): "Could not initiate ChainReplicationRMIServer";
    }

    chainReplicationFSLocalInterface = new ChainReplicationFSLocalInterface(chainReplicationOverlogNode,
                                                                            myNodeId, 
                                                                            chainReplicationFSRMIServerImpl);
    chainReplicationFS =  new ChainReplicationFS(chainReplicationFSLocalInterface, nfs);
    
    TupleHandler th = new ChainReplicationHeadTupleHandler(chainReplicationFSLocalInterface);
    chainReplicationOverlogNode.registerHandler(th);

    th = new ChainReplicationTailTupleHandler(chainReplicationFSLocalInterface);
    chainReplicationOverlogNode.registerHandler(th);
    
    th = new ChainReplicationObjVolTupleHandler(chainReplicationOverlogNode, chainReplicationFSRMIServerImpl);
    chainReplicationOverlogNode.registerHandler(th);

    th = new ChainReplicationRecvAckTupleHandler(syncBox);
    chainReplicationOverlogNode.registerHandler(th);
    
  }

 /** 
 *  Start the node 
 **/ 

  public void start() throws Exception {
    chainReplicationOverlogNode.start();
    chainReplicationFSRMIServerImpl.start();
  }


 /** 
 *  shutdown the node 
 **/ 

  public void shutdown() throws Exception {
    chainReplicationOverlogNode.shutdown();
  }


 /** 
 *  returns the FSLocalInterface 
 **/ 
  public ChainReplicationFSLocalInterface getFSInterface(){
    return chainReplicationFSLocalInterface;
  }

 /** 
 *  returns the FSRMIServerImpl 
 **/ 
  public ChainReplicationFSRMIServerImpl getFSRMIServerImpl(){
    return chainReplicationFSRMIServerImpl;
  }



 /** 
 *  returns the FS 
 **/ 
  public ChainReplicationFS getFS(){
    return chainReplicationFS;
  }

 /** 
 *  register handler -- used by experiments 
 **/ 
  public void registerHandler(TupleHandler th) {
    chainReplicationOverlogNode.registerHandler(th);
  }


 /** 
 *   main method 
 **/ 

  public static void main(String args[]) {
    if (args.length < 6 ) {
      System.out.println("Usage: ChainReplicationNode configfile p2configfile nodeId cleanDb overlogfile nodemapfile");
      return;
    }
    
    ChainReplicationNode node = new ChainReplicationNode(args[0],
                                                         args[1],
                                                         new NodeId(new Long(args[2]).longValue()),
                                                         new Boolean(args[3]).booleanValue(),
                                                         args[4],
                                                         args[5],
                                                         false,  // not thro NFS
                                                         false); // enable vol
    try{
      node.start();
    }catch(Exception e) {
      e.printStackTrace();
    }
  }
}
 /** 
/* $Log: ChainReplicationNode.java,v $
/* Revision 1.8  2007/06/04 21:41:00  zjiandan
/* expose stream catchup type CP|LOG option to rmiClient.subscribeInval().
/*
/* Revision 1.7  2007/03/15 19:41:33  nalini
/* *** empty log message ***
/*
/* Revision 1.6  2007/03/15 02:13:29  nalini
/* added a method
/*
/* Revision 1.5  2007/03/12 03:37:07  nalini
/* Chain Replication exp1 files added
/*
/* Revision 1.4  2007/03/11 21:19:55  nalini
/* chain replication consistency and volume revamped
/*
/* Revision 1.3  2007/02/12 06:19:49  zjiandan
/* Expose noSyncLog parameter, add more unittest for PRACTIFS, PangaeaFS.
/*
/* Revision 1.2  2007/01/21 19:23:19  nalini
/* ChainReplication works with NFS -- needed change NFSlib so that chainRep node makes root locally
/*
/* Revision 1.1  2007/01/18 23:47:14  nalini
/* chain replication case study added
/*
 */
 **/ 
