 /** 
/* ChainReplicationObjVolTupleHanlder
 * 
 * Handler for getObjVolume tuple handler
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

public class ChainReplicationObjVolTupleHandler extends TupleHandler {
  
  private URAOverlogNode crNode;
  private ChainReplicationFSRMIServerImpl serverImpl;
  
  private boolean dbg = false;

  public ChainReplicationObjVolTupleHandler(URAOverlogNode crNode,
                                            ChainReplicationFSRMIServerImpl serverImpl){
   super("getObjVol");
   this.crNode = crNode;
   this.serverImpl = serverImpl; 
  }
  
  public void handleTuple(Tuple tp) 
    throws MalformedTupleException {
    Env.dprintln(dbg, "ChainReplicationObjVolTupleHandler: " + tp);
    // <getObjVol, myOverlogId, ObjId, ASClk, ASNode>
    ObjId objId = new ObjId(tp.getItem(2).replaceAll("-", "/"));
    String volId = serverImpl.getVolId(objId);
    
    String[] strA = { "objVol",
                      crNode.getMyOverlogId().toString(),
                      volId,
                      tp.getItem(3),
                      tp.getItem(4)};
    Tuple t = new Tuple(strA);
    
    crNode.insertTuple(t);
  }

}

 /** 
/* $Log: ChainReplicationObjVolTupleHandler.java,v $
/* Revision 1.1  2007/03/11 21:19:55  nalini
/* chain replication consistency and volume revamped
/*
*/
 **/ 
