 /** 
/* ChainReplicationRecvAckTupleHanlder
 * 
 * Handler for getObjVolume tuple handler
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

public class ChainReplicationRecvAckTupleHandler extends TupleHandler {
  
  private SyncMailBox syncBox;
  
  private boolean dbg = false;

  public ChainReplicationRecvAckTupleHandler(SyncMailBox syncBox){
   super("recvAck");
   this.syncBox = syncBox;
  }
  
  public void handleTuple(Tuple tp) 
    throws MalformedTupleException {
    Env.dprintln(dbg, "ChainReplicationRecvTupleHandler: " + tp);
    // <recvAck, myOverlogId, senderOverlogId, volId, ASClk, ASNode>
    String volId = tp.getItem(3);
    long ts = new Long(tp.getItem(4)).longValue();
    NodeId nodeId = new NodeId(new Long(tp.getItem(5)).longValue());
    AcceptStamp as = new AcceptStamp(ts, nodeId);
    
    syncBox.recvAck(volId, as);
  }

}

 /** 
/* $Log: ChainReplicationRecvAckTupleHandler.java,v $
/* Revision 1.1  2007/03/11 21:19:55  nalini
/* chain replication consistency and volume revamped
/*
*/
 **/ 
