 /** 
/* ChainReplicationTailTupleHandler.java
 * 
 * Handler for currTail Tuple
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

public class ChainReplicationTailTupleHandler extends TupleHandler {
  
  private ChainReplicationFSLocalInterface fsLi;
  
  private boolean dbg = false;

  public ChainReplicationTailTupleHandler(ChainReplicationFSLocalInterface fsLi) {
   super("tail");
   this.fsLi = fsLi; 
  }
  
  public void handleTuple(Tuple tp) 
    throws MalformedTupleException {
    Env.dprintln(dbg, "ChainReplicationTailTupleHandler: " + tp);
    // <tail, myOverlogId, volId, tailOverlogId, P>
    String volId = tp.getItem(2);
    NodeId tailNodeId = NodeIdMap.getNodeId(new OverlogId(tp.getItem(3)));
    fsLi.recvTail(volId, tailNodeId);
  }

}

 /** 
/* $Log: ChainReplicationTailTupleHandler.java,v $
/* Revision 1.2  2007/03/11 21:19:55  nalini
/* chain replication consistency and volume revamped
/*
/* Revision 1.1  2007/01/18 23:47:14  nalini
/* chain replication case study added
/*
*/
 **/ 
