 /** 
/* ChainReplicationExp1_other
 *
 * Single Node writes and reads thro the URAOverlogInterface
 *   - makes a bunch of writes, then reads
 *   - calculates the avergage time it takes to 
 *     make write and a read.
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;

public class ChainReplicationExp1_other {

  protected static long NODE_0_ID = 0;
  protected static String CONFIG_PATH = "test" + File.separatorChar + "tmp.ChainRep.config";
  protected static String CONFIG_P2_PATH = "test" + File.separatorChar + "tmp.ChainRep.p2config";
  protected static String NODEID_MAP_PATH = "test" + File.separatorChar + "tmp.ChainRep.nodemap";
  protected  String OVERLOG_PATH = "ChainReplication.olg";
  protected static boolean disableVol = true;


  protected static int sizeOfWrites = 1000; 
  protected static int numWrites = 50; //50
  protected static byte value = 65; //"A";
  protected static long timeToWait = 500; // time to retry a read after objNotFound


  private long myNodeId = NODE_0_ID;
  private URAOverlogNode node;
  private LocalInterface li;

  
  private boolean dbg = false;


  
 /** 
 *  Constructor 
 **/ 
 
  public ChainReplicationExp1_other(String overlogFile) {

    OVERLOG_PATH=overlogFile;
    makePractiConfig(CONFIG_PATH);
    makeP2Config(CONFIG_P2_PATH);
    makeNodeIdMap(NODEID_MAP_PATH);


    node = new URAOverlogNode(CONFIG_PATH, 
                              CONFIG_P2_PATH,
                              new NodeId(myNodeId),
                              true,
                              OVERLOG_PATH,
                              NODEID_MAP_PATH,
                              false);
    li = node.getLocalInterface();

  }

 /** 
 *  Start the nodes 
 **/ 

  public void startNode() throws Exception {
    node.start();
    Thread.currentThread().sleep(1000); // wait for overlog to install
    System.out.println("Started node");
  }

 /** 
 *  Shutdown the nodes 
 **/ 

  public void shutdownNode() throws Exception {
    node.shutdown();
  }


    

 /** 
 *  Make configuration files 
 **/ 
  private static void makePractiConfig(String configPath){
    Config.createEmptyConfig();
    
    Config.addOneNodeConfig(new NodeId(NODE_0_ID),
                            "localhost",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "tmp.ChainRepTest-" + 
			    NODE_0_ID + ".db",
                            "/*",
                            -1L,
                            "localhost",
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);


    Config.writeToFile(configPath);
  }

  private static void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(NODE_0_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  private static void makeNodeIdMap(String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(NODE_0_ID), new OverlogId("localhost:5000"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }

//---------------------------------------------------------------------------
//  Converts values to byte arrays
//---------------------------------------------------------------------------

  private byte[] convertToArray(byte value){
    byte[] b = new byte[sizeOfWrites];
    for(int i = 0; i < sizeOfWrites; i++) {
      b[i] = value;
    }
    return b;
  }



//---------------------------------------------------------------------------
// makeWrites
//  - simply makes a bunch of writes
//---------------------------------------------------------------------------
  public void makeWrites() {
    try{ 
      byte[] b = convertToArray(value);
      for(int i = 0; i < numWrites; i++){
	ObjId obj = new ObjId("/" + i);
        li.write(obj, 0, b.length, b, true);
      }        
    }catch(Exception e) {
      e.printStackTrace();
      assert(false);
    }
  }

//---------------------------------------------------------------------------
// Reads 
// 
//---------------------------------------------------------------------------

  private void makeReads(){
    try{
      for(int i = 0; i < numWrites; i++){
        ObjId obj = new ObjId("/" + i);
        li.read(obj, 0, sizeOfWrites, true, true);
      }        
    }catch(Exception e) {
      e.printStackTrace();
      assert(false);
    }
  }

//---------------------------------------------------------------------------
//  print results
//---------------------------------------------------------------------------
 
 public static void printResults(long writeDuration, long readDuration, String outFile) {
    try{
      PrintStream out = new PrintStream(new FileOutputStream(outFile, true)); 
      out.println(writeDuration/numWrites + "\t" + readDuration/numWrites);
      out.close();
      
      System.out.println("Average write time = " + writeDuration/numWrites);
      System.out.println("Average read time = " + readDuration/numWrites);

    }catch(Exception e) {
      e.printStackTrace();
    }
  }

//---------------------------------------------------------------------------
//  Main  Method
//---------------------------------------------------------------------------


  public static void main(String[] args) {
    try {
      Env.verifyAssertEnabled();
      
      if(args.length < 2) {
	System.out.println("Usage: java ChainReplicationExp1 <overlogfile> <resultFile>");
	System.exit(0);
      }
      

      String olgfilename = args[0];
      String resfilename = args[1];

      ChainReplicationExp1_other exp = new ChainReplicationExp1_other(olgfilename);
      exp.startNode();
      
      System.out.println("Starting Test ..");
      
      System.out.println("Making writes");
      long writeStart = System.currentTimeMillis();
      exp.makeWrites();
      long writeEnd = System.currentTimeMillis();

      System.out.println("Making reads");
      long readStart = System.currentTimeMillis();
      exp.makeReads();
      long readEnd = System.currentTimeMillis();


      printResults((writeEnd-writeStart), (readEnd-readStart), resfilename);
      System.out.println("Finished Test ... ");
      
    }catch(Exception e) {
      e.printStackTrace();
      assert(false);
    }
    System.exit(0);
  }
  
}
//---------------------------------------------------------------------------
/* $Log: ChainReplicationExp1_other.java,v $
/* Revision 1.1  2007/03/15 00:50:14  nalini
/* exp1 checked in
/*
 */
 /** 
