import java.rmi.*;

public class LatencyTestClient {
    public static String REMOTE_HOST = "boniperti.csres.utexas.edu";
    
    public static int NUM_PINGS = 1000;
    

    private LatencyTestRMIServer server; 

    public LatencyTestClient() {
	try{
	    String lookupStr = "rmi://" + REMOTE_HOST + "/" + REMOTE_HOST + "latencyTest";
	    server = (LatencyTestRMIServer) Naming.lookup(lookupStr);
	}catch(Exception e) {
	    e.printStackTrace();
	}
    }

    public void sendPing(Object o) {
	//System.out.println("Sending obj" + o);
	try{
	   Object r =  server.ping(o);
	}catch(Exception e) {
	    e.printStackTrace();
	}
        //System.out.println("Received obj" + o);
    }

    public void startTest(Object o) {
	for(int i=0; i< NUM_PINGS; i++) {
	    sendPing(o);
	}
    }

    private byte[] convertToArray(int sizeOfWrites, byte value){
	byte[] b = new byte[sizeOfWrites];
	for(int i = 0; i < sizeOfWrites; i++) {
	    b[i] = value;
	}
    return b;
  }



    public Object createObject() {
	// creates a bound inval of 1K msg
	int size = 1000;
	ImmutableBytes imb = new ImmutableBytes(convertToArray(size, (byte)65));

	Object o = new BoundInval( new ObjId("/0"),
				   0,
				   size,
				   new AcceptStamp(-1, new NodeId(-1)),
				   imb);

	return o;
				  

    }


    public static void main(String args[]) {
	LatencyTestClient client = new LatencyTestClient();
	
	Object obj = client.createObject();
	
	System.out.println("Starting test");
	long startTime = System.currentTimeMillis();
	client.startTest(obj);
	long endTime = System.currentTimeMillis();
	
	System.out.println("Total Time = " + (endTime - startTime) + "ms" );
	System.out.println("Avg latency ("+NUM_PINGS+") :" + (endTime - startTime)/NUM_PINGS);
    }
}