 /** 
/*  MeasureInvalHandling
 * 
 *  Node 0 waits until subscripiton to
 *  NOde 1 has been attached  and then makes bound writes.
 *
 *  Turn on measureTime in IncommingInvalConnection to measure time.
 *
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

public class MeasureInvalHandling {
  
  protected static long NODE_0_ID = 0;
  protected static long NODE_1_ID = 1;
  protected static String CONFIG_PATH = "tmp.ChainRep.config";
  protected static String CONFIG_P2_PATH = "tmp.ChainRep.p2config";
  protected static String NODEID_MAP_PATH = "tmp.ChainRep.nodemap";
  protected  String OVERLOG_PATH = "InvalSub.olg";

  private static String node1Hostname = "localhost";
  private static String node2Hostname = "localhost";


  protected static int sizeOfWrites = 100; //1k
  protected static int numWrites = 10; //100
  protected static byte value = 65; //"A";

  private long myNodeId;

  private URAOverlogNode node;
  private LocalInterface li;


 /** 
 *   Constructor 
 **/ 


  public MeasureInvalHandling(String node1Hostname, String node2Hostname, long myId) {

    this.node1Hostname = node1Hostname;
    this.node2Hostname = node2Hostname;
    this.myNodeId = myId;
  
    makePractiConfig(node1Hostname, node2Hostname,CONFIG_PATH);
    makeP2Config(CONFIG_P2_PATH);
    makeNodeIdMap(node1Hostname, node2Hostname, NODEID_MAP_PATH);
    
    node = new URAOverlogNode(CONFIG_PATH,
			      CONFIG_P2_PATH,
			      new NodeId(myNodeId),
			      true,
			      OVERLOG_PATH,
			      NODEID_MAP_PATH,
			      false);
    
    li = node.getLocalInterface();

    TupleHandler th = new AliveTupleHandler();
    node.registerHandler(th);
    th = new ExpEndTupleHandler();
    node.registerHandler(th);
    th = new ExpStartTupleHandler();
    node.registerHandler(th);
    th = new NodeStartTupleHandler();
    node.registerHandler(th);

  }  



 /** 
 *  Make configuration 
 **/ 
    public static void makePractiConfig(String node1name, String node2name, String configPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(NODE_0_ID),
                            node1name,
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                           "ChainRep_Test-" + 
			    NODE_0_ID + ".db",
                            "/*",
                            -1L,
                            node1name,
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
    Config.addOneNodeConfig(new NodeId(NODE_1_ID),
			   node2name,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "ChainRep_Test-" + 
			   NODE_1_ID+".db",
			   "/*",
			   -1L,
			   node2name,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   Config.writeToFile(configPath);
  }

 public static void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(NODE_0_ID), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(NODE_1_ID), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  public static void makeNodeIdMap(String node1name, String node2name, String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(NODE_0_ID), new OverlogId(node1name+":5000"));
    NodeIdMap.add(new NodeId(NODE_1_ID), new OverlogId(node2name+":5001"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }



 //---------------------------------------------------------------------------
// Starts Practi and Overlog
//---------------------------------------------------------------------------
  public void start() {
    try{
      node.start();
    }catch(Exception e) {
      e.printStackTrace();
      assert(false);
    }
  }

//---------------------------------------------------------------------------
//  Node 1 version of test
//---------------------------------------------------------------------------

  public void testNode1() {
    // node 1 tries to ping node 0 to see if it is alive
    // then it doesn't need to do anything
    //  Overlog will automatically set up the invalidations
    waitForNodeStart();
    System.out.println("Node started -- checking to see if neighbor alive");
    checkIfAlive(NODE_0_ID);
    System.out.println("Neighbor alive -- waiting for exp to end");
    waitForEndExp();
  }
 

  private boolean nodeStarted = false;
  private boolean neighborAlive = false;
  private boolean expEnd = false;
  
  public synchronized void checkIfAlive(long neighbor) {
    while(!neighborAlive) {
      String[] stringA = {"areYouAlive", 
                          NodeIdMap.getOverlogId(new NodeId(myNodeId)).toString(),
                          NodeIdMap.getOverlogId(new NodeId(neighbor)).toString()};
      Tuple t = new Tuple(stringA);
      node.insertTuple(t);
      try{
        wait(2000);
      }catch(InterruptedException e) {
        // do nothing and continue
      }
      System.out.println("Gonna ping again");
    }
  }

  public synchronized void yesAlive() {
    neighborAlive = true;
    notifyAll();
  }
    

 public synchronized void waitForNodeStart() {
    while(!nodeStarted) {
      try{
	wait();
      }catch(InterruptedException e) {}
    }
  }

  public synchronized void nodeStarted() {
    nodeStarted = true;
    notifyAll();
  }

  public synchronized void waitForEndExp() {
    while(!expEnd) {
      try{
	wait();
      }catch(InterruptedException e) {}
    }
  }

  public synchronized void expEnd() {
    expEnd = true;
    notifyAll();
  }

//---------------------------------------------------------------------------
// Node 0 version of test
//---------------------------------------------------------------------------

  
  public void testNode0() {
    // node 0 waits for start signal
    System.out.println("Waiting for start Signal");
    waitForStartExp();
    
    System.out.println("Gonna make writes");
    makeWrites();

    System.out.println("Finished writes");

    try{
      Thread.currentThread().sleep(2000);  // make sure the invals go thro'
    }catch(InterruptedException e) {}  
    //insert finishedExp
    String[] stringA = {"finishedExp", 
                          NodeIdMap.getOverlogId(new NodeId(NODE_0_ID)).toString(),
                          NodeIdMap.getOverlogId(new NodeId(NODE_1_ID)).toString()};
    Tuple t = new Tuple(stringA);
    node.insertTuple(t);
      
  }
  
  private boolean expStart = false;

  public synchronized void waitForStartExp() {
    while(!expStart) {
      try{
	wait();
      }catch(InterruptedException e) {}
    }
  }

  public synchronized void expStart() {
    expStart = true;
    notifyAll();
  }


//---------------------------------------------------------------------------
// makeWrites
//  - simply makes a bunch of writes
//---------------------------------------------------------------------------
  public void makeWrites() {
    try{ 
      byte[] b = convertToArray(value);
      for(int i = 0; i < numWrites; i++){
	ObjId obj = new ObjId("/" + i);
        li.write(obj, 0, b.length, b, true);
      }        
    }catch(Exception e) {
      e.printStackTrace();
      assert(false);
    }
  }

//---------------------------------------------------------------------------
//  Converts values to byte arrays
//---------------------------------------------------------------------------

  private byte[] convertToArray(byte value){
    byte[] b = new byte[sizeOfWrites];
    for(int i = 0; i < sizeOfWrites; i++) {
      b[i] = value;
    }
    return b;
  }

//---------------------------------------------------------------------------
//   main method
//---------------------------------------------------------------------------

  
  public static void main(String[] args) {
    if(args.length < 3) {
      System.out.println("Usage: MeasureInvalHandling <node1name> <node2name> <nodeId>");
      return;
    }

    MeasureInvalHandling exp = new MeasureInvalHandling(args[0],
							args[1],
							(new Long(args[2])).longValue());

    exp.start();

    exp.runTest();
    
    System.out.println("Finished Experiment...");
    System.exit(0);
  }

 //---------------------------------------------------------------------------
// runTest
//---------------------------------------------------------------------------
  

  public void runTest(){
    if(myNodeId == NODE_0_ID){
      testNode0();
    }
    if(myNodeId == NODE_1_ID){
      testNode1();
    }
  }

//---------------------------------------------------------------------------
// AliveTupleHandler -- watches yesAlive tuple
//---------------------------------------------------------------------------

  class AliveTupleHandler extends TupleHandler {

    public AliveTupleHandler() {
      super("yesAlive");
    }

    public void handleTuple(Tuple tp) {
      yesAlive();
    }
  }


//---------------------------------------------------------------------------
// ExpEndTupleHandler -- watches expFinished handler
//---------------------------------------------------------------------------

   class ExpEndTupleHandler extends TupleHandler {
     
     public ExpEndTupleHandler() {
       super("expEnd");
     }

     public void handleTuple(Tuple tp) {
       expEnd();
     }
   }

//---------------------------------------------------------------------------
// ExpStartTupleHandler -- watches expFinished handler
//---------------------------------------------------------------------------

   class ExpStartTupleHandler extends TupleHandler {
     
     public ExpStartTupleHandler() {
       super("expStart");
     }

     public void handleTuple(Tuple tp) {
       expStart();
     }
   }
  

//---------------------------------------------------------------------------
// nodestart tuple handler
//---------------------------------------------------------------------------

   class NodeStartTupleHandler extends TupleHandler {
     
     public NodeStartTupleHandler() {
       super("started");
     }

     public void handleTuple(Tuple tp) {
       nodeStarted();
     }
   }
  
}
