 /** 
/*  CR_Exp2_MakeConfig
 *
 * hard codes config file so that the chain is 
 *
 * Node 0 - boniperti - master
 * Node 1 - rossi - head (has populated DB)
 * Node 2 - riva 
 * Node 3 - mazzola
 * 
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

public class CR_Exp2_MakeConfig {
  public static String CONFIG_PATH = "CR_Exp2.config";
  public static String CONFIG_P2_PATH = "CR_Exp2.p2config";
  public static String NODEID_MAP_PATH = "CR_Exp2.nodemap";
  private static String headDbPathPrefix = "CR_Exp2_PopulatedDb_copy";
  private static String defaultDbPathPrefix = "CR_Exp2";

 /** 
 *  Make configuration 
 **/ 
  public static synchronized void makePractiConfig(String configPath) {
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(0),
                            "boniperti.csres.utexas.edu",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            defaultDbPathPrefix+".db",
                            "/*",
                            -1L,
                            "boniperti.csres.utexas.edu",
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
                            50000000,
                            50000000);

    Config.addOneNodeConfig(new NodeId(1),
                            "rossi.csres.utexas.edu",
                            9788,
                            9789,
                            9791,
                            9792,
                            9790,
                            headDbPathPrefix+".db",
                            "/*",
                            -1L,
                            "rossi.csres.utexas.edu",
                            9793,
                            9794,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
                            50000000,
                            50000000);

    Config.addOneNodeConfig(new NodeId(2),
                            "riva.csres.utexas.edu",
                            9888,
                            9889,
                            9891,
                            9892,
                            9890,
                            defaultDbPathPrefix+".db",
                            "/*",
                            -1L,
                            "riva.csres.utexas.edu",
                            9893,
                            9894,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
                            50000000,
                            50000000);

    Config.addOneNodeConfig(new NodeId(3),
                            "mazzola.csres.utexas.edu",
                            9688,
                            9689,
                            9691,
                            9692,
                            9690,
                            defaultDbPathPrefix+".db",
                            "/*",
                            -1L,
                            "mazzola.csres.utexas.edu",
                            9693,
                            9694,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
                            50000000,
                            50000000);

    Config.writeToFile(configPath);
  }

 public static synchronized void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(0), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(1), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(2), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(3), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  public static synchronized  void makeNodeIdMap(String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(0), new OverlogId("boniperti.csres.utexas.edu:5000"));
    NodeIdMap.add(new NodeId(1), new OverlogId("rossi.csres.utexas.edu:5001"));
    NodeIdMap.add(new NodeId(2), new OverlogId("riva.csres.utexas.edu:5002"));
    NodeIdMap.add(new NodeId(3), new OverlogId("mazzola.csres.utexas.edu:5003"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }

//---------------------------------------------------------------------------
// main method
//---------------------------------------------------------------------------

  public static void main(String args[]) {
    makePractiConfig(CONFIG_PATH);
    makeP2Config(CONFIG_P2_PATH);
    makeNodeIdMap(NODEID_MAP_PATH);
    System.out.println("done");
  }
}

