 /** 
/*  CR_Exp2_PopulateDB.java
 * 
 *  Populates DB on a per volume basis
 *  Populates it with bound writes
 * 
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;

public class CR_Exp2_PopulateDB {

  private int numVols = 1; 
  private int numObjsPerVol = 100;
  private int sizeOfObj = 1000;
 private static byte value = 65; // A

  private URAOverlogNode node;
  private LocalInterface li;
  
  public static long NODE_1_ID = 1;
  public static String CONFIG_PATH = "CR_Exp2_PopulateDB.config";
  public static String CONFIG_P2_PATH = "CR_Exp2_PopulateDB.p2config";
  public static String NODEID_MAP_PATH = "CR_Exp2_PopulateDB.nodemap";
  public static String OVERLOG_PATH = "Garbage.olg";
  private static String dbPathPrefix = "PopulatedDb";

 /** 
 *  Constructor 
 **/ 


  public CR_Exp2_PopulateDB (String dbPath) {
    this.dbPathPrefix = dbPath;
    makePractiConfig(CONFIG_PATH);
    makeP2Config(CONFIG_P2_PATH);
    makeNodeIdMap(NODEID_MAP_PATH);
    
    node = new URAOverlogNode(CONFIG_PATH, 
                               CONFIG_P2_PATH,
                               new NodeId(NODE_1_ID),
                               true,
                               OVERLOG_PATH,
                               NODEID_MAP_PATH,
                               false);

    li = node.getLocalInterface();
  }

 /** 
 *  Make configuration 
 **/ 
  public static synchronized void makePractiConfig(String configPath) {
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(NODE_1_ID),
                            "localhost",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            dbPathPrefix+".db",
                            "/*",
                            -1L,
                            "localhost",
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
    Config.writeToFile(configPath);
  }

 public static synchronized void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(NODE_1_ID), 5, 5, 30000000, 30000000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  public static synchronized  void makeNodeIdMap(String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(NODE_1_ID), new OverlogId("localhost:5000"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }

//---------------------------------------------------------------------------
//  Starts the Overlog 
//---------------------------------------------------------------------------
   
  public synchronized void startNode() throws Exception{
    //start node without overlog
    node.start(true);
    wait(2000);
  }

//---------------------------------------------------------------------------
// shutdown
//---------------------------------------------------------------------------
   
  public synchronized void shutdown() throws Exception{
    node.shutdown();
  }
  

//---------------------------------------------------------------------------
//  Converts values to byte arrays
//---------------------------------------------------------------------------

  private synchronized byte[] convertToArray(int size, byte value){
    byte[] b = new byte[size];
    for(int i = 0; i < size; i++) {
      b[i] = value;
    }
    return b;
  }


//---------------------------------------------------------------------------
//  Writes <numObjects> of <b> to dir <path>
//---------------------------------------------------------------------------

  private void writeDir(String path, int numObjects, byte[] b){
    
    for(int i=0; i < numObjects; i++){
      ObjId objId = new ObjId(path + "/" + i);      
      try{
        li.write(objId, 0, b.length, b, true);
      }catch(Exception e) {
        e.printStackTrace();
      }
    }
  }

//---------------------------------------------------------------------------
//  populate DB
//---------------------------------------------------------------------------
  private void populateDB() {
    byte[] b = convertToArray(sizeOfObj, value);

    for(int v = 0; v< numVols; v++) {
      System.out.println("Populating volume " + v);
        writeDir("/"+v, numObjsPerVol, b);
    }
  }

//---------------------------------------------------------------------------
// main method
//---------------------------------------------------------------------------

  public static void main(String[] args) {

    if (args.length < 1) {
      System.out.println("Usage: CR_Exp2_PopulateDB <dbPathPrefix> " );
      return;
    }

    CR_Exp2_PopulateDB exp = new CR_Exp2_PopulateDB(args[0]);

    try{ 
      exp.startNode();
      exp.populateDB();
      exp.shutdown();
    }catch(Exception e) {
      e.printStackTrace();
    }
    System.out.println("DB Population Ended"); 
    System.exit(0);
  }
}

//---------------------------------------------------------------------------
/* $Log: CR_Exp2_PopulateDB.java,v $
/* Revision 1.1  2007/03/17 01:37:23  nalini
/* CR_Exp2 config updated
/*
*/
 /** 
