 /** 
/* CR_Exp2_TestRunner
 *  
 * invokes TestClients with % of update queries to the chain
 *
 *  and measures throughput
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;
import java.lang.*;

public class CR_Exp2_TestRunner {
  
  private int timeForTest = 2 * 60 * 1000; 
  private int numChainNodes;
  private int updatePercent;
  private int numClients;
  private TestClient[] testClients;
  private String outFile;
  
  private boolean dbg = true;

  public CR_Exp2_TestRunner(String configFile,
			    int numChainNodes, 
                            int updatePercent, 
                            int numClients, 
                            String outFile) {
    this.numChainNodes = numChainNodes;
    this.updatePercent = updatePercent;
    this.numClients = numClients;
    this.outFile = outFile;
    this.testClients = new TestClient[numClients];
    for(int i = 0 ; i < numClients; i++) {
      testClients[i] = new TestClient(configFile, numChainNodes, updatePercent, i);
    }
    
  }

  public void start() {

    System.out.println("TestRunner: starting test for numNodes=" +numChainNodes +
                       " updatePercent=" + updatePercent + " numClients=" + numClients);
    try{

    Env.dprintln(dbg, "TestRunner: starting the clients .. ");
    
    Thread[] threads = new Thread[numClients];
    for(int i = 0; i < numClients; i++){
      threads[i] = new Thread(testClients[i]);
      threads[i].start();
    }

    Env.dprintln(dbg, "TestRunner: waiting for " + timeForTest);
    Thread.currentThread().sleep(timeForTest);

    Env.dprintln(dbg, "Requesting all threads to stop");
     for(int i = 0; i < numClients; i++){
       testClients[i].stopClient();
     }

     Env.dprintln(dbg, "Waiting for threads to stop");
     for(int i = 0; i < numClients; i++){
       try{
         threads[i].join(1000);
       }catch(InterruptedException e) {}
     }

     Env.dprintln(dbg, "Calculating average throughput");
     double total = 0;
     for(int i = 0; i < numClients; i++){
       total += testClients[i].getThroughput();
     }
     
     double throughput = total/numClients;
     System.out.println("Throughput: " + throughput);

     printResults(throughput);

    }catch(Exception e) {
      e.printStackTrace();
    }
  }

   
  public void printResults(double throughput){
    try{
      PrintStream out = new PrintStream(new FileOutputStream(outFile, true)); 
      out.println(numChainNodes+"\t"+ updatePercent + "\t" + throughput);
      out.close();
    }catch(Exception e) {}
  }

  public static void main(String args[]) {
    if(args.length < 4) {
      System.out.println("CR_Exp2_TestRunner <configFile> <numChainNodes> <updatePercent> <numClients> <outFile");
      return;
    }

    CR_Exp2_TestRunner testRunner = new CR_Exp2_TestRunner(args[0],
							   (new Integer(args[1])).intValue(),
                                                           (new Integer(args[2])).intValue(),
                                                           (new Integer(args[3])).intValue(),
                                                           args[4]);

    testRunner.start();

    System.exit(0);
  }   
}
      
    
    
  

  