#!/bin/bash

#
#  run from the code/case-studies/Bayou  directory
#
export JAVA_PATH=/usr/bin


#kill `ps aux | grep -v grep | grep rmiregistry | awk '{print $2;}'`
#sleep 2
#cd classes
#rmiregistry &
#cd ..

if [ $# -lt 1 ];
then
    echo "Usage: runChainRepNFS.sh <nodeId>  where nodeId = 0|1|2|3"
    echo "*** Note: you should start the master(Node 0) first"
else 
NODEID=$1

CHAINREP=`pwd`

echo $CHAINREP

##
## by default, the nfs.java will start the portmap.
## if set "-p" after unixnfs, it will not run the portmap thread.
## 
## Note: in mac,
## if rpcinfo -p :
##   rpcinfo: can't contact portmapper: RPC: remote system error - Connection refused
##
## this means that we need explicitly start the native mac portmap before start the server.
## to do that, just enter the following command:
## sudo launchctl start com.apple.portmap
##

#Note: we need to run from the code directory otherwise the exports file 
# doesn't work quite well
cd ../..
${JAVA_PATH}/java -agentlib:hprof -Xdebug -Xrunjdwp:transport=dt_socket,address=8000,server=y,suspend=n -esa -ea unixnfs -p chainRep $CHAINREP/ChainReplication.config $CHAINREP/ChainReplication.p2config $NODEID true $CHAINREP/ChainReplication.olg $CHAINREP/ChainReplication.nodemap  2>&1 | tee out

fi