#!/bin/bash

#  
#  Sets up a ChainRep Node
#  Usage: runChainRepNode.sh <nodeId>
#
#  run from the code/case-studies/ChainReplication  directory
# 


#  check command line argument
#

if [ $# -lt 1 ];
then
    echo "Usage: runChainRepNode.sh <nodeId> where nodeId = 0|1|2|3"
    echo "**Note** Node 0 is the master"
else 
NODEID=$1
export JAVA_PATH=/usr/bin

echo  "Setting up Node $NODEID"

CHAINREP=`pwd`

${JAVA_PATH}/java ChainReplicationNode $CHAINREP/ChainReplication.config $CHAINREP/ChainReplication.p2config $NODEID true $CHAINREP/ChainReplication.olg $CHAINREP/ChainReplication.nodemap  2>&1 | tee out

fi