 /** 
/* ChainReplicationIINode
 *
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 
import java.io.*;
import java.util.*;

public class ChainReplicationIINode {
  private PadreNode node;
  SafetyPolicyModule safetyModule;

  protected static String CONFIG_PATH = "CRII.config";
  protected static String CONFIG_P2_PATH = "CRII.p2config";
  protected static String CONFIG_P2_MAP = "CRII.nodeMap";

 /** 
 *   Constructor 
 **/ 

  public ChainReplicationIINode(String olgName, NodeId nodeId) {
    safetyModule = new ChainReplicationII_SafetyPolicyModule();
    Policy liveness = new OverlogPolicy(olgName, nodeId, CONFIG_P2_MAP);
  
    node = new PadreNode(CONFIG_PATH, CONFIG_P2_PATH, nodeId,
                         true, false, safetyModule, liveness);
  }

 /** 
 *  Starts  the node 
 **/ 
 
  public void start()throws Exception {
    node.start();
  }
 

 /** 
 *  shuts down node 
 **/ 
 
  public void shutdown()throws Exception {
    node.shutdown();
  }

 /** 
 *  Get method for SafetyModule 
 **/ 
  public SafetyPolicyModule getSafetyModule(){
    return safetyModule;
  }



 /** 
 *  Main - starts the node 
 **/ 
 
  public static void main(String[] args){
    try{
      if (args.length < 2) {
        System.out.println("Usage: CRIINode <olgName>  <nodeId>");
        System.exit(0);
      }
      
      String olgPath = args[0];
      NodeId nodeId = new NodeId((new Long(args[1])).longValue());
      
      ChainReplicationIINode cRIINode = 
        new ChainReplicationIINode(olgPath, nodeId);
      
      cRIINode.start();
      
      cRIINode.userInterface(System.in);
    }catch(Exception e) {
      e.printStackTrace();
    }
  }
 
 
 /** 
 *  UserInterface -- for testing purposes 
 **/ 
 
  public void userInterface(InputStream is){
    
    boolean dbg = true;
    long accumulatedTimeMillis = 0;
    long nextWriteExpectedTime = System.currentTimeMillis();
    long startTime = System.currentTimeMillis();
    long writeNum = 0;

    System.out.println("Enter action:  ");
    System.out.println("Comments       : c [comments]");
    System.out.println("Write          : w [ObjId] [String]");
    System.out.println("Read           : r [ObjId] [String]");
    System.out.println("End            : e");
    
    BufferedReader din = null;
		
    try{
      din = new BufferedReader(new InputStreamReader(is));
		
      System.out.print("Enter command: ");
      String input;
      for(input = din.readLine(); input!= null; input=din.readLine()) {
        
	
        byte[] action = input.getBytes();
		
        if(action[0] == 'w'){
          writeNum++;
          StringTokenizer st = new StringTokenizer(input.substring(2));
          ObjId objId = new ObjId(st.nextToken());
          String str = "";
	  while(st.hasMoreElements()){
	    str = str+st.nextToken();
	    str += " ";
	  }
	  str.trim();
         

	  try{
	    Env.dprintln(dbg, "Writing obj:" + objId);
	    safetyModule.write(objId, 0, str.length(), new ImmutableBytes(str.getBytes()));
	  }catch(Exception e){
	    e.printStackTrace();
	    //continue
	  }
		    
        } else if (action[0] == 'r'){
	  StringTokenizer st = new StringTokenizer(input.substring(2));
          ObjId objId = new ObjId(st.nextToken());
          String str = "";
	  
          try{
	    Env.dprintln(dbg, "Reading obj:" + objId);
	    BodyMsg bm = safetyModule.read(objId, 0, 10000);
	    str = bm.getBody().toString();
	    System.out.println(str);
          }catch(Exception e){
            //
            // ObjNotFoundException or EOFException
            //
	    e.printStackTrace();
	    //continue;
          }
                    
        } else if (action[0] == 'e'){
          System.exit(-1);

       
        } else if (action[0] == 'c'){
          // Do nothing
        } 
	System.out.print("Enter command: ");
      }//for
    } catch (Exception e){
      e.printStackTrace();
      System.out.println("Wrong input format ...");
    }	
  }
}
  