 /** 
/* ChainReplicationII_safetyPolicyModule
 *
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

public class ChainReplicationII_SafetyPolicyModule extends SafetyPolicyModule {
  boolean dbg = true;

  public ChainReplicationII_SafetyPolicyModule() {
    readBlockImprecise = true;
    readBlockInvalid = true;
  }

  public void registerMsgs(){
    slBridge.registerMsgToListen("receivedServerAck", new AckMsgMatcher());
  }

  void readAfterPredicate(ObjId objId, long offset, long length, BodyMsg bMsg){}
  void writeBeforePredicate(ObjId objId, long offset, long length){}
 

  void writeAfterPredicate(ObjId objId, long offset, long length){
    try{
    BodyMsg bMsg = li.read(objId, offset, length, true, false, Long.MAX_VALUE, -1);
    AcceptStamp as = bMsg.getAcceptStamp();

    String[] msg = {"receivedServerAck", 
                    (new Long(as.getLocalClock())).toString(), 
                    as.getNodeId().toString()};
    if(dbg){System.out.println("waiting for ack");}
    slBridge.waitForLivenessMsg(msg);

    if(dbg){System.out.println("received ack");}
    }catch(Exception e) {
      if(dbg) {
        e.printStackTrace();
      }
    }
  }

  public class AckMsgMatcher implements MsgMatcher {

    public boolean match(String[] requiredMsg, String[] receivedMsg){
      if(dbg) { 
        System.out.println("Trying to match requiredMsg: " + convertToString(requiredMsg) +
                           "and receivedMsg:" + convertToString(receivedMsg));
      }
      AcceptStamp requiredAS = 
        new AcceptStamp((new Long(requiredMsg[1])).longValue(), 
                        new NodeId((new Long(requiredMsg[2])).longValue()));
                     
      
      AcceptStamp receivedAS = 
        new AcceptStamp((new Long(receivedMsg[1])).longValue(), 
                        new NodeId((new Long(receivedMsg[2])).longValue()));
      
      if(requiredAS.leq(receivedAS)){
        return true;
      } 
      return false;
    }

    private String convertToString(String[] stringA){
      String str = "[";
      for(int i=0; i<stringA.length; i++){
        str+=stringA[i] + ":";
      }

      str +="]";

      return str;
    }

  }
}




