 /** 
/* CodaColdCachePerformance.java
 *
 * Create Practi URANode and Overlog Engine, and test performance for hot cache
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;
import java.util.*;

public class CodaColdCachePerformance{
  final static boolean useOldP2 = true;
  final static long primary = 0;
  final static boolean dbg = true;
  final static int objSize = 1;
  final static int totalWrites = 10;

  protected static long SERVER_ID = 0;
  protected static long CLIENT1_ID = 1;
  protected static long CLIENT2_ID = 2;
  protected static long CLIENT3_ID = 3;
  protected static long CLIENT4_ID = 4;
  protected static String CONFIG_PATH = "test" + File.separatorChar + "codacsres.config";
  protected static String CONFIG_P2_PATH = "test" + File.separatorChar + "codacsres.p2config";
  protected static String NODEID_MAP_PATH = "test" + File.separatorChar + "codacsres.nodemap";
 /** 
 *  Make configuration files 
 **/ 
  private static void makePractiConfig(String configPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(SERVER_ID),
                            "rossi.csres.utexas.edu",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "codacsres-" + 
			    SERVER_ID + ".db",
                            "/*",
                            -1L,
                            "rossi.csres.utexas.edu",
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(CLIENT1_ID),
			   "boniperti.csres.utexas.edu",
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT1_ID+".db",
			   "/*",
			   -1L,
			   "boniperti.csres.utexas.edu",
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

Config.addOneNodeConfig(new NodeId(CLIENT2_ID),
			   "mazzola.csres.utexas.edu",
			   9788,
			   9789,
			   9791,
			   9792,
                            9790,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT2_ID+".db",
			   "/*",
			   -1L,
			   "mazzola.csres.utexas.edu",
			   9793,
			   9794,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    
   Config.addOneNodeConfig(new NodeId(CLIENT3_ID),
			   "rossi.csres.utexas.edu",
			   9788,
			   9789,
			   9791,
			   9792,
                            9790,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT3_ID+".db",
			   "/*",
			   -1L,
			   "rossi.csres.utexas.edu",
			   9793,
			   9794,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.addOneNodeConfig(new NodeId(CLIENT4_ID),
			   "rossi.csres.utexas.edu",
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT4_ID+".db",
			   "/*",
			   -1L,
			   "rossi.csres.utexas.edu",
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.writeToFile(configPath);
  }

  private static void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(SERVER_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT1_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT2_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT3_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT4_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  private static void makeNodeIdMap(String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(SERVER_ID), new OverlogId("rossi.csres.utexas.edu:5000"));
    NodeIdMap.add(new NodeId(CLIENT1_ID), new OverlogId("boniperti.csres.utexas.edu:5001"));
    NodeIdMap.add(new NodeId(CLIENT2_ID), new OverlogId("mazzola.csres.utexas.edu:5002"));
    NodeIdMap.add(new NodeId(CLIENT3_ID), new OverlogId("rossi.csres.utexas.edu:5003"));
    NodeIdMap.add(new NodeId(CLIENT4_ID), new OverlogId("rossi.csres.utexas.edu:5004"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }

  public static void populate(CodaLocalInterface li){
    BufferedReader din = null;
    System.out.println(" Wait for p2 and uraNode finishing start up,"
		       + " then Press <ENTER> to start.");
    
    byte[] dataArr = new byte[objSize];
    for(int i = 0; i < objSize; i++){
      dataArr[i] = 'a';
    }
    long start, end, totalMS;

    try{
      din = new BufferedReader(new InputStreamReader(System.in));
      din.readLine();
      start = System.currentTimeMillis();
      for(int i = 0; i < totalWrites; i++){
	ObjId objId = new ObjId("/"+i);
	li.write(objId, 0, objSize, dataArr);
      }
      end = System.currentTimeMillis();
      System.out.println(" write performance: " + ((end-start)/(double)totalWrites)
			 + " ms " + "dataSize= " + objSize);
      
      start = System.currentTimeMillis();
      for(int i = 0; i < totalWrites; i++){
	ObjId objId = new ObjId("/"+i);
	li.read(objId, 0, objSize);
      }
      end = System.currentTimeMillis();
      System.out.println(" read performance: " + ((end-start)/(double)totalWrites)
			 + " ms " + "dataSize= " + objSize);
      } catch (Exception e){
      e.printStackTrace();
    }

  }

  public static void readPerformance(CodaLocalInterface li){
    BufferedReader din = null;
    System.out.println(" Wait for writes finish,"
                       + " then Press <ENTER> to start.");

    byte[] dataArr = new byte[objSize];
    for(int i = 0; i < objSize; i++){
      dataArr[i] = 'a';
    }
    long start, end, totalMS;

    try{
      din = new BufferedReader(new InputStreamReader(System.in));
      din.readLine();
      start = System.currentTimeMillis();
      /*
      for(int i = 0; i < totalWrites; i++){
        ObjId objId = new ObjId("/"+i);
        li.write(objId, 0, objSize, dataArr);
      }
      end = System.currentTimeMillis();
      System.out.println(" write performance: " + ((end-start)/(double)totalWrites)
                         + " ms " + "dataSize= " + objSize);

      */
      start = System.currentTimeMillis();
      for(int i = 0; i < totalWrites; i++){
        ObjId objId = new ObjId("/"+i);
        li.read(objId, 0, objSize);
      }
      end = System.currentTimeMillis();
      System.out.println(" read performance: " + ((end-start)/(double)totalWrites)
                         + " ms " + "dataSize= " + objSize);
    } catch (Exception e){
      e.printStackTrace();
    }

  }

  public static void main(String[] argv)
  throws Exception{
    int myId = 0;
    
    makePractiConfig(CONFIG_PATH);
    makeP2Config(CONFIG_P2_PATH);
    makeNodeIdMap(NODEID_MAP_PATH);

    if (argv.length >= 1){
      myId = new Integer(argv[0]).intValue();
      System.out.println(" node " + myId + " running");
    }
    CodaURAOverlogNode uraNode = new CodaURAOverlogNode(CONFIG_PATH,
							CONFIG_P2_PATH,
							new NodeId(myId),
							true,
							"case-studies/Coda/Coda.olg",	
							NODEID_MAP_PATH,
							false);

    Env.dprintln(dbg, "uraNode created");
    System.out.println(" PRESS any key to start the test...");
    if(argv[1].equals("w")){
      populate(uraNode.getTLI());
      populate(uraNode.getTLI());
    }else{
      readPerformance(uraNode.getTLI());
      readPerformance(uraNode.getTLI());  
    }
    
  }
}

 /** 
/* $Log: CodaColdCachePerformance.java,v $
/* Revision 1.3  2007/10/06 18:44:06  zjiandan
/* *** empty log message ***
/*
/* Revision 1.2  2007/10/04 03:30:23  zjiandan
/* add more nodes to coda test.
/*
/* Revision 1.1  2007/10/03 20:26:57  zjiandan
/* *** empty log message ***
/* */
 **/ 
