 /** 
/* CodaURAOverlogNode.java
 *
 * Create Practi URANode and Overlog Engine, and a CodaFS (local interface)
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;
import java.util.*;

public class CodaTestOnCS{
  protected static long SERVER_ID = 0;
  protected static long CLIENT1_ID = 1;
  protected static long CLIENT2_ID = 2;
  protected static String CONFIG_PATH = "test" + File.separatorChar + "codacs.config";
  protected static String CONFIG_P2_PATH = "test" + File.separatorChar + "codacs.p2config";
  protected static String NODEID_MAP_PATH = "test" + File.separatorChar + "codacs.nodemap";
 /** 
 *  Make configuration files 
 **/ 
  private static void makePractiConfig(String configPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(SERVER_ID),
                            "localhost",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "codacs-" + 
			    SERVER_ID + ".db",
                            "/*",
                            -1L,
                            "localhost",
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(CLIENT1_ID),
			   "localhost",
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "codacs-" + 
			   CLIENT1_ID+".db",
			   "/*",
			   -1L,
			   "localhost",
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

Config.addOneNodeConfig(new NodeId(CLIENT2_ID),
			   "localhost",
			   9788,
			   9789,
			   9791,
			   9792,
                            9790,
                           "test" + File.separatorChar + "codacs-" + 
			   CLIENT2_ID+".db",
			   "/*",
			   -1L,
			   "localhost",
			   9793,
			   9794,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    
   Config.writeToFile(configPath);
  }

  private static void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(SERVER_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT1_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT2_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  private static void makeNodeIdMap(String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(SERVER_ID), new OverlogId("localhost:5000"));
    NodeIdMap.add(new NodeId(CLIENT1_ID), new OverlogId("localhost:5001"));
    NodeIdMap.add(new NodeId(CLIENT2_ID), new OverlogId("localhost:5002"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }

  public static void main(String[] argv)
  throws Exception{
    int myId = 0;
    String olgFileName = "case-studies/Coda/CodaOnCS.olg";
    makePractiConfig(CONFIG_PATH);
    makeP2Config(CONFIG_P2_PATH);
    makeNodeIdMap(NODEID_MAP_PATH);
    if (argv.length == 1){
      myId = new Integer(argv[0]).intValue();
    }
    CodaURAOverlogNode uraNode = new CodaURAOverlogNode(CONFIG_PATH,
							CONFIG_P2_PATH,
							new NodeId(myId),
							true,
							olgFileName,				  
							NODEID_MAP_PATH, 
							false);
    
    
    
    uraNode.userInterface(System.in);
  }
}

//---------------------------------------------------------------------------
/* $Log: CodaTestOnCS.java,v $
/* Revision 1.1  2007/03/13 00:04:44  zjiandan
/* mv test to cs machines.
/* */
 /** 
