 /** 
/* CodaTestOnCSRES.java
 *
 * Create Practi URANode and Overlog Engine, and a CodaFS (local interface)
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;
import java.util.*;

public class CodaTestOnCSRES{
  protected static long SERVER_ID = 0;
  protected static long CLIENT1_ID = 1;
  protected static long CLIENT2_ID = 2;
  protected static String CONFIG_PATH = "test" + File.separatorChar + "codacsres.config";
  protected static String CONFIG_P2_PATH = "test" + File.separatorChar + "codacsres.p2config";
  protected static String NODEID_MAP_PATH = "test" + File.separatorChar + "codacsres.nodemap";
 /** 
 *  Make configuration files 
 **/ 
  private static void makePractiConfig(String configPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(SERVER_ID),
                            "rossi.csres.utexas.edu",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "codacsres-" + 
			    SERVER_ID + ".db",
                            "/*",
                            -1L,
                            "rossi.csres.utexas.edu",
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(CLIENT1_ID),
			   "boniperti.csres.utexas.edu",
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT1_ID+".db",
			   "/*",
			   -1L,
			   "boniperti.csres.utexas.edu",
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

Config.addOneNodeConfig(new NodeId(CLIENT2_ID),
			   "mazzola.csres.utexas.edu",
			   9788,
			   9789,
			   9791,
			   9792,
                            9790,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT2_ID+".db",
			   "/*",
			   -1L,
			   "mazzola.csres.utexas.edu",
			   9793,
			   9794,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    
   Config.writeToFile(configPath);
  }

  private static void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(SERVER_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT1_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT2_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  private static void makeNodeIdMap(String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(SERVER_ID), new OverlogId("rossi.csres.utexas.edu:5000"));
    NodeIdMap.add(new NodeId(CLIENT1_ID), new OverlogId("boniperti.csres.utexas.edu:5001"));
    NodeIdMap.add(new NodeId(CLIENT2_ID), new OverlogId("mazzola.csres.utexas.edu:5002"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }

  public static void main(String[] argv)
  throws Exception{
    int myId = 0;
    String olgFileName = "case-studies/Coda/Coda.olg";
    makePractiConfig(CONFIG_PATH);
    makeP2Config(CONFIG_P2_PATH);
    makeNodeIdMap(NODEID_MAP_PATH);
    if (argv.length == 1){
      myId = new Integer(argv[0]).intValue();
    }
    CodaURAOverlogNode uraNode = new CodaURAOverlogNode(CONFIG_PATH,
							CONFIG_P2_PATH,
							new NodeId(myId),
							true,
							olgFileName,				  
							NODEID_MAP_PATH, 
							false);
    
    
    
    uraNode.userInterface(System.in);
  }
}

//---------------------------------------------------------------------------
/* $Log: CodaTestOnCSRES.java,v $
/* Revision 1.1  2007/10/02 20:10:03  zjiandan
/*  Coda with recovery of server or client tested
/* */
 /** 
