 /** 
/* CodaURAOverlogNode.java
 *
 * Create Practi URANode and Overlog Engine, and a CodaFS (local interface)
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;
import java.util.*;

public class CodaURAOverlogNode extends URAOverlogNode{
  final static boolean useOldP2 = false;
  final static long primary = 0;
  final static boolean dbg = true;
  //final CodaFS pfs;
  //  final PRACTIP2Interface ppi;
  CodaLocalInterface tli;
  public CodaURAOverlogNode(String configPath, 
			    String p2ConfigPath, 
			    NodeId nodeId,
			    boolean cleanDb,
			    String overlogPath,
			    String nodeMapPath,
			    boolean noSyncLog){
    
    super(configPath, p2ConfigPath, nodeId, cleanDb, overlogPath, nodeMapPath, noSyncLog);
    Env.dprintln(dbg, "creating CodaFS");
    /*
    if(useOldP2){
      //super.getP2Runtime().getCore().setCatchupTypeToCP(true);//set the catchup type to be CP
    }else{
      //assert false:"add CP to all subscribeInval tuple in Coda.olg";
    }
    */
    tli = new CodaLocalInterface(li, nodeId);
    //initConfig();
    //pfs = new CodaFS(tli,
    //   overlogPolicy, nodeId.equals(new NodeId(primary)));
    //    ppi = new PRACTIP2Interface(tli, overlogPolicy);
    Env.dprintln(dbg, "creating CodaFS done");
    overlogPolicy.registerHandler(new IsConnectedHandler(tli));
    overlogPolicy.registerHandler(new WriteFinishedHandler(tli));
    // Env.dprintln(dbg, "creating CodaFS done 1");
    
    
    
    if(dbg){
      System.out.println("CodaURAOverlogNode( " + configPath + ", "
                         + p2ConfigPath + ", "
                         + nodeId + ", "
                         + overlogPath + ", "
                         + nodeMapPath + ") starts ...");
    }
    try{
      super.start();
    }catch(Exception e){
      e.printStackTrace();
      System.exit(1);
    }

  }

  public CodaFS getFS(){
    return null;
  }

  public CodaLocalInterface getTLI(){
    return this.tli;
  }

  public void userInterface(InputStream is){
    boolean dbgWriteScript = false;
    
    long accumulatedTimeMillis = 0;
    long nextWriteExpectedTime = System.currentTimeMillis();
    long startTime = System.currentTimeMillis();
    long writeNum = 0;

    Env.printDebug("Enter action:  ");
    Env.printDebug("Comments       : c [comments]");
    Env.printDebug("write          : w [ObjId] [String]");
    Env.printDebug("GetAcceptStamp : r [ObjId] [String]");
    Env.printDebug("end            : e");

    BufferedReader din = null;
		
    try{
	    		
      din = new BufferedReader(new InputStreamReader(is));
		
	    
      String input;
      for(input = din.readLine(); input!= null; input=din.readLine()) {
        
        System.err.println("Input : " + input);
        byte[] action = input.getBytes();
		
        if(action[0] == 'w'){
          writeNum++;
          StringTokenizer st = new StringTokenizer(input.substring(2));
          ObjId objId = new ObjId(st.nextToken());
          String str = "";
	  while(st.hasMoreElements()){
	    str = str+st.nextToken();
	    str += " ";
	  }
	  str.trim();
         
	  Env.dprintln(dbg, "str to write to object " + objId.toString()+ ":" + str);
	  try{
	    //PRACTIFileOutputStream pos = new PRACTIFileOutputStream(this.tli, objId);
	    //ObjectOutputStream oos = new ObjectOutputStream(pos);
	    	  
	    //oos.writeObject(str);
	    //oos.flush();
	    this.tli.write(objId, 0, str.length(), str.getBytes());
	  }catch(Exception e){
	    e.printStackTrace();
	    //continue
	  }
		    
        } else if (action[0] == 'r'){
	  StringTokenizer st = new StringTokenizer(input.substring(2));
          ObjId objId = new ObjId(st.nextToken());
          String str = "";
	  
          //PRACTIFileInputStream pis = null;
          //ObjectInputStream ois = null;
          try{
	    //pis = new PRACTIFileInputStream(this.tli, objId, 1000);
	    //ois = new ObjectInputStream(pis);
	    
	    //str = (String)(ois.readObject());
	    BodyMsg bm = this.tli.read(objId, 0, 10000);
	    str = bm.getBody().toString();
	    Env.dprintln(dbg, "read object " + objId.toString() + " :" + str);
	    
          }catch(Exception e){
            //
            // ObjNotFoundException or EOFException
            //
	    e.printStackTrace();
	    //continue;
          }
                    
        } else if (action[0] == 'e'){
          System.exit(-1);

       
        } else if (action[0] == 'c'){
          // Do nothing
        } 
      }//for
    } catch (Exception e){
      e.printStackTrace();
      Env.printDebug("Wrong input format ...");
    }	
  }

  protected static long SERVER_ID = 0;
  protected static long CLIENT1_ID = 1;
  protected static long CLIENT2_ID = 2;
  protected static long CLIENT3_ID = 3;
  protected static long CLIENT4_ID = 4;
  protected static String CONFIG_PATH = "test" + File.separatorChar + "codacsres.config";
  protected static String CONFIG_P2_PATH = "test" + File.separatorChar + "codacsres.p2config";
  protected static String NODEID_MAP_PATH = "test" + File.separatorChar + "codacsres.nodemap";
 /** 
 *  Make configuration files 
 **/ 
  private static void makePractiConfig(String configPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(SERVER_ID),
                            "localhost",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "codacsres-" + 
			    SERVER_ID + ".db",
                            "/*",
                            -1L,
                            "localhost",
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(CLIENT1_ID),
			   "localhost",
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT1_ID+".db",
			   "/*",
			   -1L,
			   "localhost",
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

Config.addOneNodeConfig(new NodeId(CLIENT2_ID),
			   "localhost",
			   9788,
			   9789,
			   9791,
			   9792,
                            9790,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT2_ID+".db",
			   "/*",
			   -1L,
			   "localhost",
			   9793,
			   9794,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    
   Config.addOneNodeConfig(new NodeId(CLIENT3_ID),
			   "localhost",
			   9788,
			   9789,
			   9791,
			   9792,
                            9790,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT3_ID+".db",
			   "/*",
			   -1L,
			   "localhost",
			   9793,
			   9794,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.addOneNodeConfig(new NodeId(CLIENT4_ID),
			   "localhost",
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT4_ID+".db",
			   "/*",
			   -1L,
			   "localhost",
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.writeToFile(configPath);
  }

  private static void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(SERVER_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT1_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT2_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT3_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT4_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  private static void makeNodeIdMap(String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(SERVER_ID), new OverlogId("localhost:5000"));
    NodeIdMap.add(new NodeId(CLIENT1_ID), new OverlogId("localhost:5001"));
    NodeIdMap.add(new NodeId(CLIENT2_ID), new OverlogId("localhost:5002"));
    NodeIdMap.add(new NodeId(CLIENT3_ID), new OverlogId("localhost:5003"));
    NodeIdMap.add(new NodeId(CLIENT4_ID), new OverlogId("localhost:5004"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }
  
  public static void main(String[] argv)
  throws Exception{

    makePractiConfig(CONFIG_PATH);
    makeP2Config(CONFIG_P2_PATH);
    makeNodeIdMap(NODEID_MAP_PATH);
    int myId = 0;
    
    if (argv.length == 1){
      myId = new Integer(argv[0]).intValue();
      System.out.println(" node " + myId + " running");
    }
    CodaURAOverlogNode uraNode = new CodaURAOverlogNode(CONFIG_PATH,
							CONFIG_P2_PATH,
							new NodeId(myId),
							true,
							"demo/Coda.olg",	
							NODEID_MAP_PATH, 
							false);

    Env.dprintln(dbg, "uraNode created");
    
    uraNode.userInterface(System.in);
  }
}

//---------------------------------------------------------------------------
/* $Log: CodaURAOverlogNode.java,v $
/* Revision 1.12  2007/10/19 23:08:40  zjiandan
/* Coda demo for SOSP poster 2007.
/*
/* Revision 1.11  2007/10/06 18:44:06  zjiandan
/* *** empty log message ***
/*
/* Revision 1.10  2007/10/04 03:43:03  zjiandan
/*  add more nodes
/*
/* Revision 1.9  2007/10/03 23:50:35  nalini
/* moved coda to P2 version 0.8.2
/*
/* Revision 1.8  2007/10/03 20:26:00  zjiandan
/* Cooperative cache.
/*
/* Revision 1.7  2007/10/02 20:10:03  zjiandan
/*  Coda with recovery of server or client tested
/*
/* Revision 1.4  2007/03/13 08:15:24  zjiandan
/* Coda Tested with S-C1-C2 scenarios as described in CodaTest.olg.
/*
/* Revision 1.3  2007/03/13 00:04:44  zjiandan
/* mv test to cs machines.
/*
/* Revision 1.2  2007/03/12 23:10:40  zjiandan
/* Minor change for the tuples.
/*
/* Revision 1.1  2007/03/12 03:07:26  zjiandan
/* Coda Localinterface.
/* */
 /** 
