 /** 
/* IsConnectedHandler.java
 *
 * Handle "isConnected(ME, 1|0)" Tuple received from P2 
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

public class IsConnectedHandler extends TupleHandler{
  static final boolean sanityCheck = true;
  static final boolean dbg = true;
  CodaLocalInterface pfs;
  public IsConnectedHandler(CodaLocalInterface pfs){
    super("isConnected");
    this.pfs = pfs;
  }

  public void handleTuple(Tuple tp)
    throws MalformedTupleException{
    if(tp.getLength() != 3) {
      throw new MalformedTupleException("tp=" + tp + "length = " +tp.getLength() + " expected:3");
    }
    //assert tp.getItem(1)== myoverlogid;
    String statusStr = tp.getItem(2);
    boolean isConnected = statusStr.equals("1");
    //Env.dprintln(dbg, "received "+ tp.toString());
    pfs.setConnectedStatus(isConnected);
  }
}

 /** 
/* $Log: IsConnectedHandler.java,v $
/* Revision 1.4  2007/10/02 20:10:03  zjiandan
/*  Coda with recovery of server or client tested
/*
/* Revision 1.3  2007/03/13 08:15:24  zjiandan
/* Coda Tested with S-C1-C2 scenarios as described in CodaTest.olg.
/*
/* Revision 1.2  2007/03/12 23:10:40  zjiandan
/* Minor change for the tuples.
/*
/* Revision 1.1  2007/03/12 03:07:26  zjiandan
/* Coda Localinterface.
/* */
 **/ 
