 /** 
 *  ReadOfInvalidCacheException -- thrown when a read hits an imprecise 
 *  object 
 **/ 
import java.io.IOException;

public class ReadOfInvalidCacheException extends IOException
{
  private String errStr;
  
  private ObjId objId;
 /** 
 *  Constructor 
 **/ 
  public ReadOfInvalidCacheException(String errorString, ObjId objId)
  {
    this.errStr = errorString;
    this.objId = objId; 
  }

 /** 
 *  Constructor 
 **/ 
    public ReadOfInvalidCacheException(ObjId objId)
    {
      this.errStr = "";
	this.objId = objId;
    }

 /** 
 *  Convert this exception to a string 
 **/ 
    public String toString()
    {
      return("ReadOfInvalidCacheException:" + this.errStr
	     + " obj: " + objId.toString() + ".");
    }

    
}

 /** 
/* $Log: ReadOfInvalidCacheException.java,v $
/* Revision 1.1  2007/03/12 03:07:26  zjiandan
/* Coda Localinterface.
/* */
 **/ 
