 /** 
/* WriteFinishedHandler.java
 *
 * Handle "writeFinished(ME, TS, ME)" Tuple received from P2 
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

public class WriteFinishedHandler extends TupleHandler{
  static final boolean sanityCheck = true;
  static final boolean dbg = true;
  CodaLocalInterface pfs;
  public WriteFinishedHandler(CodaLocalInterface pfs){
    super("writeFinished");
    this.pfs = pfs;
  }

  public void handleTuple(Tuple tp)
    throws MalformedTupleException{
    if(tp.getLength() != 4) {
      throw new MalformedTupleException("tp=" + tp + " leng=" + tp.getLength() + " expected: 4");
    }
    //assert tp.getItem(1)== myoverlogid;
    if(sanityCheck){
      tp.getItem(1).equals(tp.getItem(3));//equals to my overlogId
    }
    long timestamp = new Long(tp.getItem(2)).longValue();
    NodeId gid = new NodeId(new Long(tp.getItem(3)).longValue());
    AcceptStamp as = new AcceptStamp(timestamp, gid);
    //Env.dprintln(dbg, "received " + tp.toString());
    pfs.writeFinished(as);
    
  }
}

 /** 
/* $Log: WriteFinishedHandler.java,v $
/* Revision 1.4  2007/10/02 20:10:03  zjiandan
/*  Coda with recovery of server or client tested
/*
/* Revision 1.3  2007/03/13 08:15:24  zjiandan
/* Coda Tested with S-C1-C2 scenarios as described in CodaTest.olg.
/*
/* Revision 1.2  2007/03/12 23:10:40  zjiandan
/* Minor change for the tuples.
/*
/* Revision 1.1  2007/03/12 03:07:26  zjiandan
/* Coda Localinterface.
/* */
 **/ 
