 /** 
/**
 *  CodaClientController
 *     
 *   setup subscriptions for client readMiss
 */
 **/ 
public class CodaClientController extends LocalController{

  
  static final boolean dbg = false;
  RMIClient rmiClient = null;
  NodeId myNodeId = null;
  NodeId serverId = null;
  CodaMailBox mb = null;
  protected static boolean turnOnMailBox = !RMIServerImpl.turnOffSyncRequest;

  public CodaClientController(RMIClient rmiClient, NodeId myNodeId, NodeId serverId,
			      CodaMailBox mb){
    super();
    this.rmiClient = rmiClient;
    this.myNodeId = myNodeId;
    this.serverId = serverId;
    this.mb = mb;
  }

 /** 
 *  Read miss 
 **/ 
  public void informLocalReadImprecise(ObjId objId, long offset, long length){
    Env.dprintln(dbg, "informLocalReadImprecise");
    try{
      rmiClient.subscribeInval(serverId, myNodeId.getIDint(), objId.toString(), true);
    }catch(Exception e){
    
      e.printStackTrace();
      assert false: "can't subscribe from server for unblocking LocalReadImprecise";
    }
  }

 /** 
 *  Read miss 
 **/ 
  public void informLocalReadInvalid(ObjId objId, long offset, long length,
				     AcceptStamp inval){
    Env.dprintln(dbg, "informLocalReadInvalid:" + objId + " " + offset 
		 + " " + length + " " + inval);
    try{
      rmiClient.subscribeInval(serverId, myNodeId.getIDint(), objId.toString(), true);
    }catch(Exception e){
    
      e.printStackTrace();
      assert false: "can't subscribe from server for unblocking LocalReadImprecise";
    }
  }
  
 /** 
 *  Sync Reply received 
 **/ 
  public void  recvSyncReply(AcceptStamp acceptStamp, NodeId sender){
    Env.dprintln(dbg, "recvSyncReply" + acceptStamp + " from " + sender.toString());
    try{
      if(turnOnMailBox){
	mb.got(acceptStamp);
      }
    }catch(Exception e){
    
      e.printStackTrace();
      assert false: "can't subscribe from server for unblocking LocalReadImprecise";
    }
  }
  
}


 /** 
/* $Log: CodaClientController.java,v $
/* Revision 1.2  2007/10/07 04:47:04  zjiandan
/*  coda cooperative caching exp
/**/
 **/ 
