 /** 
/**
 *  CodaClientExpt2Controller
 *     
 *   setup subscriptions for client readMiss
 */
 **/ 
public class CodaClientExpt2Controller extends LocalController{

  private static final boolean cooperativeCaching = CodaExpt2Server.cooperativeCaching;
  static final boolean dbg = false;
  RMIClient rmiClient = null;
  NodeId myNodeId = null;
  NodeId serverId = null;
  CodaMailBox mb = null;
  int clientNum = 0;
  protected static boolean turnOnMailBox = !RMIServerImpl.turnOffSyncRequest;

  public CodaClientExpt2Controller(RMIClient rmiClient, NodeId myNodeId, NodeId serverId,
				   CodaMailBox mb,
				   int clientNum){
    super();
    this.rmiClient = rmiClient;
    this.myNodeId = myNodeId;
    this.serverId = serverId;
    this.mb = mb;
    this.clientNum = clientNum;
  }

 /** 
 *  Read miss 
 **/ 
  public void informLocalReadImprecise(ObjId objId, long offset, long length){
    Env.dprintln(dbg, "informLocalReadImprecise");

    try{
      int objIdInt = new Integer(objId.toString().substring(1)).intValue();
      int readerId = objIdInt % CodaExpt2Client1.clientNum;
      Env.dprintln(dbg, "readerId=" +readerId);
      if((!cooperativeCaching) || (readerId==0)){
	rmiClient.subscribeInval(serverId, myNodeId.getIDint(), objId.toString(), true);
      }else{
	assert cooperativeCaching;
        
	Env.dprintln(dbg, "subscribeInval from " + (readerId+1) + " to me " + objId.toString()); 
	rmiClient.subscribeInval(new NodeId(readerId+1), myNodeId.getIDint(), objId.toString(), true);
      
      }
    }catch(Exception e){
    
      e.printStackTrace();
      assert false: "can't subscribe from server for unblocking LocalReadImprecise";
    }
  }

 /** 
 *  Read miss 
 **/ 
  public void informLocalReadInvalid(ObjId objId, long offset, long length,
				     AcceptStamp inval){
    Env.dprintln(dbg, "informLocalReadInvalid:" + objId + " " + offset 
		 + " " + length + " " + inval);
    try{
      int objIdInt = new Integer(objId.toString().substring(1)).intValue();
      int readerId = objIdInt % CodaExpt2Client1.clientNum;
      Env.dprintln(dbg, "readerId=" +readerId);
      if((!cooperativeCaching) || (readerId==0)){
	rmiClient.subscribeInval(serverId, myNodeId.getIDint(), objId.toString(), true);
      }else{
	assert cooperativeCaching;
        
	Env.dprintln(dbg, "subscribeInval from " + (readerId+1) + " to me " + objId.toString()); 
	rmiClient.subscribeInval(new NodeId(readerId+1), myNodeId.getIDint(), objId.toString(), true);
      
      }
    }catch(Exception e){
    
      e.printStackTrace();
      assert false: "can't subscribe from server for unblocking LocalReadImprecise";
    }
  }
  
 /** 
 *  Sync Reply received 
 **/ 
  public void  recvSyncReply(AcceptStamp acceptStamp, NodeId sender){
    Env.dprintln(dbg, "recvSyncReply" + acceptStamp + " from " + sender.toString());
    try{
      if(turnOnMailBox){
	mb.got(acceptStamp);
      }
    }catch(Exception e){
    
      e.printStackTrace();
      assert false: "can't subscribe from server for unblocking LocalReadImprecise";
    }
  }
  
}


 /** 
/* $Log: CodaClientExpt2Controller.java,v $
/* Revision 1.2  2007/10/07 05:06:48  zjiandan
/* *** empty log message ***
/*
/* Revision 1.1  2007/10/07 04:53:11  zjiandan
/*  coopeartive cachine
/**/
 **/ 
