 /** 
 *  Local interface created for the CodaFS 
 **/ 
import java.util.HashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Iterator;
import java.io.IOException;
import java.io.EOFException;

public class CodaClientLocalInterface extends PRACTIFSLocalInterface{
  private static final boolean cooperativeCaching = true;
  private static final long READTIMEOUT = 1000000; //10 sec
  
  private static final boolean dbg = false;
 /** 
 *  Data members 
 **/ 
  //private boolean connected;//server connection status
  //private CodaP2MailBox mailBox;

  private NodeId serverId = null;
  private RMIClient rmiClient = null;
  private CodaMailBox mb = null;
 /** 
 *  Constructor 
 **/ 
  public
    CodaClientLocalInterface(LocalInterface li, NodeId myNodeId, NodeId serverId,
			     RMIClient rmiClient,
			     CodaMailBox mb){
    
    super(li, myNodeId);
    this.serverId = serverId;
    this.rmiClient = rmiClient;
    this.mb = mb;
    //connected = true;
    //mailBox = new CodaP2MailBox();
  }

 /** 
 *  Constructor 
 **/ 
  public
    CodaClientLocalInterface(PRACTIFSLocalInterface li, NodeId myNodeId, 
			     NodeId serverId,
			     RMIClient rmiClient,
			     CodaMailBox mb){
    super(li, myNodeId);
    this.serverId = serverId;
    //connected = true;
    //mailBox = new CodaP2MailBox();
    this.rmiClient = rmiClient;
    this.mb = mb;

  }

 /** 
 *  Read from an object  
 *  Coda sepcific parameters: 
 *      blockValid = true; blockPrecise = true 
 *  
 *  tbd: if disconnected from server while read is blocked because of 
 *       imprecise or valid, it will hang till the timeout. 
 *       Throws ReadTimeoutException in this case 
 *         
 *  side effect: 
 *    1. disconnected and imprecise or invalid 
 *       ---> throw ReadOfInvalidCacheObjException 
 *    2. block imprecise /invalid timeout 
 *       ---> throw ReadTimeoutException 
 *    both exception are subclass of IOException and treated as IOException 
 *    in NFS interface. 
 **/ 
  public BodyMsg
    read(ObjId objId,
	 long offset,
	 long length)
  throws ObjNotFoundException, IOException,
	 EOFException, ReadOfHoleException{
    Env.dprintln(dbg, "CodaClientLocalInterface:: read "+ objId + " off=" + offset + " len= " + length);
  
    /*
    if(!connected && !cooperativeCaching){//disconnected and imprecise
      if((!this.li.isPrecise(objId))||(!this.li.isValid(objId, offset, length))){
	throw new ReadOfInvalidCacheException(objId);
      }
    }
    */
    BodyMsg result = null;    
    try{
      result = this.li.read(objId,
                            offset,
                            length,
                            true,//blockValid
                            true,
			    READTIMEOUT);//blockPrecise
    }catch(ReadOfInvalidRangeException rire){
      assert false;//because of blockValid is true

    }catch(ReadTimeoutException rte){
    
	Env.dprintln(dbg, rte.toString() + " \n -- have you set the readtimeout"
		     + " too short?");
	throw rte;
    
    }
    //Env.dprintln(dbg, "CodaClientLocalInterface:: read "+ objId + " off=" + offset + " len= " + length + " done");
    return(result);
  }

 /** 
 *  overload the original method in PRACTIFS 
 **/ 
  public long write(ObjId objId, long offset, long length, byte buffer[])
    throws IOException {
    Env.dprintln(dbg, "CodaClientLocalInterface:: write "
		 + objId + " off=" + offset + " len= " + length);
    PreciseInv resultSummary = null;
    resultSummary=li.preWrite(objId, offset, length, 
			      new ImmutableBytes(buffer), true, 1L);//bound = true, maxHop =1
    
    try{
      rmiClient.requestSync(serverId, super.getMyNodeId(), resultSummary.getAcceptStamp());
      if(CodaClientController.turnOnMailBox){
	mb.waitFor(resultSummary.getAcceptStamp());
      }
    }catch(Exception e){
      e.printStackTrace();
      assert false;
    }
    
    Env.dprintln(dbg, "CodaClientLocalInterface:: write done "+ objId 
		 + " off=" + offset + " len= " + length + " done");
    return resultSummary.getLength();
  }

  /*
    defer
  //-----------------------------------------------------------------------
  // Version of the write() method that allows writing to multiple
  // object atomically
  //-----------------------------------------------------------------------
  protected long[]
  writeMulti(MultiWriteEntry[] mwe, boolean embargoed)
    throws IOException{
    MultiObjPreciseInv result = null;
    Env.dprintln(dbgLock||dbg, "CodaClientLocalInterface::writeMulti");
    // Pass the call onto the real LocalInterface
    result = this.li.preWriteMulti(mwe, embargoed);
    
    if(connected){
      try{
	mailBox.waitFor(writeResult.getAcceptStamp());
      }catch(ServerDisconnectedException e){
	//ignore
      }
    }
    Env.dprintln(dbgLock||dbg, "return CodaClientLocalInterface::writeMulti");
    return result.getLength(); 
  }
  */
  
  
 /** 
 *  write 
 *  need to know the timestamp so that it knows when to wait 
 **/ 
  /*
  //-----------------------------------------------------------------------
  // Used for testing
  //-----------------------------------------------------------------------
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing CodaClientLocalInterface.java...");
    CodaClientLocalInterface.testSimple();
    System.out.println("...CodaClientLocalInterface.java");
    System.exit(0);
  }

  //-----------------------------------------------------------------------
  // Used for testing
  //-----------------------------------------------------------------------
  private static void
  testSimple(){
    CodaClientLocalInterface li = null;
    FakePRACTIFSLocalInterface fakeLI = null;
    PRACTIFSReadLockToken readToken = null;
    PRACTIFSWriteLockToken writeToken = null;

    fakeLI = new FakePRACTIFSLocalInterface(new NodeId(1));
    li = new CodaClientLocalInterface(fakeLI, new NodeId(1));
    try{
      // Try one objId
      readToken = li.acquireReadLock(new ObjId("a"));
      assert(readToken.getObjId().equals(new ObjId("a")));
      assert(readToken.isAcquired());
      li.releaseReadLock(readToken, new ObjId("a"));
      assert(!readToken.isAcquired());
      writeToken = li.acquireWriteLock(new ObjId("a"));
      assert(writeToken.getObjId().equals(new ObjId("a")));
      assert(writeToken.isAcquired());
      li.releaseWriteLock(writeToken, new ObjId("a"));
      assert(!writeToken.isAcquired());

      // Try two objIds
      readToken = li.acquireReadLock(new ObjId("a"));
      assert(readToken.getObjId().equals(new ObjId("a")));
      assert(readToken.isAcquired());
      writeToken = li.acquireWriteLock(new ObjId("b"));
      assert(writeToken.getObjId().equals(new ObjId("b")));
      assert(writeToken.isAcquired());
      li.releaseWriteLock(writeToken, new ObjId("b"));
      li.releaseReadLock(readToken, new ObjId("a"));
    }catch(InterruptedException e){
      System.err.println("" + e);
    }
  }
*/
}
 /** 
/* $Log: CodaClientLocalInterface.java,v $
/* Revision 1.2  2007/10/07 04:47:04  zjiandan
/*  coda cooperative caching exp
/*
/* Revision 1.1  2007/10/06 05:29:53  zjiandan
/* Add Coda java hack version.
/* */
 **/ 
