 /** 
/* CodaExpt1Server.java
 *
 * Create Practi URANode and Overlog Engine, and test performance for hot cache
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;
import java.util.*;

public class CodaExpt1Server{
  
  public static final int BARRIER_PORT = 9743;

  final static boolean useOldP2 = true;
  final static long primary = 0;
  final static boolean dbg = true;
  protected final static int objSize = 1;
  protected final static int totalWrites = 1000;
  

  protected static long SERVER_ID = 0;
  protected static long CLIENT1_ID = 1;
  protected static long CLIENT2_ID = 2;
  protected static long CLIENT3_ID = 3;
  protected static long CLIENT4_ID = 4;
  protected static String CONFIG_PATH = "test" + File.separatorChar + "codacsres.config";
  protected static String CONFIG_P2_PATH = "test" + File.separatorChar + "codacsres.p2config";
  protected static String NODEID_MAP_PATH = "test" + File.separatorChar + "codacsres.nodemap";
  protected static String CLIENT_1 = "rossi.csres.utexas.edu";
  protected static String CLIENT_3 = "mazzola.csres.utexas.edu";
  protected static String CLIENT_2 = "riva.csres.utexas.edu";
  protected static String CLIENT_4 = "localhost";

 /** 
 *  Make configuration files 
 **/ 
  private static void makePractiConfig(String configPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(SERVER_ID),
                            CLIENT_1,
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "codacsres-" + 
			    SERVER_ID + ".db",
                            "/*",
                            -1L,
                            CLIENT_1,
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(CLIENT1_ID),
			   CLIENT_2,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT1_ID+".db",
			   "/*",
			   -1L,
			   CLIENT_2,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

Config.addOneNodeConfig(new NodeId(CLIENT2_ID),
			   CLIENT_3,
			   9788,
			   9789,
			   9791,
			   9792,
                            9790,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT2_ID+".db",
			   "/*",
			   -1L,
			   CLIENT_3,
			   9793,
			   9794,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    
   Config.addOneNodeConfig(new NodeId(CLIENT3_ID),
			   CLIENT_1,
			   9788,
			   9789,
			   9791,
			   9792,
                            9790,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT3_ID+".db",
			   "/*",
			   -1L,
			   CLIENT_1,
			   9793,
			   9794,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.addOneNodeConfig(new NodeId(CLIENT4_ID),
			   CLIENT_1,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT4_ID+".db",
			   "/*",
			   -1L,
			   CLIENT_1,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.writeToFile(configPath);
  }
  /*
  private static void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(SERVER_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT1_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT2_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT3_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT4_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  private static void makeNodeIdMap(String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(SERVER_ID), new OverlogId(CLIENT_1+":5000"));
    NodeIdMap.add(new NodeId(CLIENT1_ID), new OverlogId(CLIENT_2+":5001"));
    NodeIdMap.add(new NodeId(CLIENT2_ID), new OverlogId("CLIENT_3:5002"));
    NodeIdMap.add(new NodeId(CLIENT3_ID), new OverlogId(CLIENT_1+":5003"));
    NodeIdMap.add(new NodeId(CLIENT4_ID), new OverlogId(CLIENT_1+":5004"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }
  */
  public static void populate(CodaServerLocalInterface li){
    BufferedReader din = null;
    System.out.println(" Wait for p2 and uraNode finishing start up,"
		       + " then Press <ENTER> to start.");
    
    byte[] dataArr = new byte[objSize];
    for(int i = 0; i < objSize; i++){
      dataArr[i] = 'a';
    }
    long start, end, totalMS;

    try{
      //din = new BufferedReader(new InputStreamReader(System.in));
      //din.readLine();
      start = System.currentTimeMillis();
      for(int i = 0; i < totalWrites; i++){
	ObjId objId = new ObjId("/"+i);
	li.write(objId, 0, objSize, dataArr);
      }
      end = System.currentTimeMillis();
      System.out.println(" write performance: " + ((end-start)/(double)totalWrites)
			 + " ms " + "dataSize= " + objSize);
      
      start = System.currentTimeMillis();
      for(int i = 0; i < totalWrites; i++){
	ObjId objId = new ObjId("/"+i);
	li.read(objId, 0, objSize);
      }
      end = System.currentTimeMillis();
      System.out.println(" read performance: " + ((end-start)/(double)totalWrites)
			 + " ms " + "dataSize= " + objSize);
      } catch (Exception e){
      e.printStackTrace();
    }

  }

  public static void readPerformance(CodaServerLocalInterface li){
    BufferedReader din = null;
    System.out.println(" Wait for writes finish,"
                       + " then Press <ENTER> to start.");

    byte[] dataArr = new byte[objSize];
    for(int i = 0; i < objSize; i++){
      dataArr[i] = 'a';
    }
    long start, end, totalMS;

    try{
      din = new BufferedReader(new InputStreamReader(System.in));
      din.readLine();
      start = System.currentTimeMillis();
      /*
      for(int i = 0; i < totalWrites; i++){
        ObjId objId = new ObjId("/"+i);
        li.write(objId, 0, objSize, dataArr);
      }
      end = System.currentTimeMillis();
      System.out.println(" write performance: " + ((end-start)/(double)totalWrites)
                         + " ms " + "dataSize= " + objSize);

      */
      start = System.currentTimeMillis();
      for(int i = 0; i < totalWrites; i++){
        ObjId objId = new ObjId("/"+i);
        li.read(objId, 0, objSize);
      }
      end = System.currentTimeMillis();
      System.out.println(" read performance: " + ((end-start)/(double)totalWrites)
                         + " ms " + "dataSize= " + objSize);
    } catch (Exception e){
      e.printStackTrace();
    }

  }

  public static void main(String[] argv)
  throws Exception{
    Process rmiregistry = null;
    try{
      rmiregistry = Runtime.getRuntime().exec("rmiregistry");

	System.out.println("rmiregistry started");

      Thread.sleep(2000);
    }catch(Exception e){
      // Non-fatal exception; we just killed it to 
      // ensure we could start it. Now try starting it.
    }

    makePractiConfig(CONFIG_PATH);
    //    makeP2Config(CONFIG_P2_PATH);
    //    makeNodeIdMap(NODEID_MAP_PATH);

    //
    // Start barrier server
    //
    BarrierServer barrier = new BarrierServer(BARRIER_PORT, 2, BarrierServer.LOOP_FOREVER);
    barrier.start();
    
    NodeId myNodeId = new NodeId(SERVER_ID);
    NodeId clientId = new NodeId(CLIENT1_ID);
    
    //create everything -- URANode
    RMIClient rmiClient = new RMIClient();
    boolean filterOn = true;
    boolean cleanDb = true;
    boolean noSyncLog = true;

    Core core = new Core(rmiClient, filterOn, cleanDb, myNodeId, noSyncLog);
    Controller controller = new LocalController();
    RMIServerImpl rmiServer = new RMIServerImpl(core, controller);
    rmiServer.start();
    SocketServer socketServer = new SocketServer(core, controller);
    
    LocalInterface localInterface = new LocalInterface(controller, core);
    CodaServerLocalInterface li = new CodaServerLocalInterface(localInterface, myNodeId);
    
    core.recoverLocalState(rmiServer);
    
    BarrierClient bc = new BarrierClient(CLIENT_1, BARRIER_PORT, 0);
    Env.dprintln(dbg, "uraNode created");
   
    bc.sendBarrierRequest(0, 0); // 1 We are up and running; helper is up
    
    try{
      //server --> client for empty subscriptionset
      
      rmiClient.subscribeInval(myNodeId, clientId.getIDint(), "/never", true);
      //client --> server for "/*" subscriptionset
      rmiClient.subscribeInval(clientId, myNodeId.getIDint(), "/*", true);
     
    }catch(Exception e){
      e.printStackTrace();
      assert false: "can't subscribe between client and server";
    }
    
    bc.sendBarrierRequest(0, 0); // 2 initial subscription done
    
    bc.sendBarrierRequest(0, 0); // 3 wait for client do first round write + read

    
    populate(li);
    
    bc.sendBarrierRequest(0, 0); // 5 tell client that I'm done
    bc.sendBarrierRequest(0, 0); // 6 wait for client done
    
    //shutdown
    rmiServer.close();
    rmiServer = null;
    socketServer.shutdown();
    socketServer = null;
    core.syncStateToDisk();
    core.close();
    core = null;
    try{
      if(rmiregistry != null){
	rmiregistry.destroy();
      }
    }catch(Exception e){
    }
  }
}

//---------------------------------------------------------------------------
/* $Log: CodaExpt1Server.java,v $
/* Revision 1.6  2007/10/07 06:20:58  zjiandan
/* *** empty log message ***
/*
/* Revision 1.5  2007/10/07 05:59:29  zjiandan
/* *** empty log message ***
/*
/* Revision 1.4  2007/10/07 04:47:04  zjiandan
/*  coda cooperative caching exp
/*
/* Revision 1.3  2007/10/06 18:44:06  zjiandan
/* *** empty log message ***
/*
/* Revision 1.2  2007/10/06 18:09:19  zjiandan
/* java version expt1 done.
/*
/* Revision 1.1  2007/10/06 05:29:53  zjiandan
/* Add Coda java hack version.
/* */
 /** 
