 /** 
/* CodaExpt2Client1.java
 *
 * Create Practi URANode and Overlog Engine, and test performance for hot cache
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;
import java.util.*;

public class CodaExpt2Client1{
  
  protected static int clientNum = 2;
  public static final int BARRIER_PORT = 9743;
  
  final static boolean useOldP2 = true;
  final static long primary = 0;
  final static boolean dbg = true;
  final static int objSize = CodaExpt2Server.objSize;
  final static int totalWrites = CodaExpt2Server.totalWrites;
  

  protected static long SERVER_ID = 0;
  protected static long CLIENT1_ID = 1;
  protected static long CLIENT2_ID = 2;
  protected static long CLIENT3_ID = 3;
  protected static long CLIENT4_ID = 4;
  protected static String CONFIG_PATH = "test" + File.separatorChar + "codacsres.config";
  protected static String CONFIG_P2_PATH = "test" + File.separatorChar + "codacsres.p2config";
  protected static String NODEID_MAP_PATH = "test" + File.separatorChar + "codacsres.nodemap";

  protected static String CLIENT_1 = CodaExpt2Server.CLIENT_1;
  protected static String CLIENT_2 = CodaExpt2Server.CLIENT_2;
  protected static String CLIENT_3 = CodaExpt2Server.CLIENT_3;
  protected static String CLIENT_4 = CodaExpt2Server.CLIENT_4;
  
 /** 
 *  Make configuration files 
 **/ 
  private static void makePractiConfig(String configPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(SERVER_ID),
                            CLIENT_1,
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "codacsres-" + 
			    SERVER_ID + ".db",
                            "/*",
                            -1L,
                            CLIENT_1,
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(CLIENT1_ID),
			   CLIENT_2,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT1_ID+".db",
			   "/*",
			   -1L,
			   CLIENT_2,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

Config.addOneNodeConfig(new NodeId(CLIENT2_ID),
			   CLIENT_3,
			   9788,
			   9789,
			   9791,
			   9792,
                            9790,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT2_ID+".db",
			   "/*",
			   -1L,
			   CLIENT_3,
			   9793,
			   9794,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    
   Config.addOneNodeConfig(new NodeId(CLIENT3_ID),
			   CLIENT_1,
			   9788,
			   9789,
			   9791,
			   9792,
                            9790,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT3_ID+".db",
			   "/*",
			   -1L,
			   CLIENT_1,
			   9793,
			   9794,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.addOneNodeConfig(new NodeId(CLIENT4_ID),
			   CLIENT_1,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "codacsres-" + 
			   CLIENT4_ID+".db",
			   "/*",
			   -1L,
			   CLIENT_1,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.writeToFile(configPath);
  }
  /*
  private static void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(SERVER_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT1_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT2_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT3_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(CLIENT4_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  private static void makeNodeIdMap(String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(SERVER_ID), new OverlogId(CLIENT_1+":5000"));
    NodeIdMap.add(new NodeId(CLIENT1_ID), new OverlogId(CLIENT_2+":5001"));
    NodeIdMap.add(new NodeId(CLIENT2_ID), new OverlogId("CLIENT_3:5002"));
    NodeIdMap.add(new NodeId(CLIENT3_ID), new OverlogId(CLIENT_1+":5003"));
    NodeIdMap.add(new NodeId(CLIENT4_ID), new OverlogId(CLIENT_1+":5004"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }
  */

  public static void populate(CodaClientLocalInterface li){
    BufferedReader din = null;
    System.out.println(" Client1 is about to populate....");
    
    byte[] dataArr = new byte[objSize];
    for(int i = 0; i < objSize; i++){
      dataArr[i] = 'a';
    }
    long start, end, totalMS;

    try{
      //din = new BufferedReader(new InputStreamReader(System.in));
      //din.readLine();
      start = System.currentTimeMillis();
      for(int i = 0; i < totalWrites; i++){
	ObjId objId = new ObjId("/"+i);
	li.write(objId, 0, objSize, dataArr);
      }
      end = System.currentTimeMillis();
      System.out.println(" write performance: " + ((end-start)/(double)totalWrites)
			 + " ms " + "dataSize= " + objSize);
      
      start = System.currentTimeMillis();
      for(int i = 0; i < totalWrites; i++){
	ObjId objId = new ObjId("/"+i);
	li.read(objId, 0, objSize);
      }
      end = System.currentTimeMillis();
      System.out.println(" read performance: " + ((end-start)/(double)totalWrites)
			 + " ms " + "dataSize= " + objSize);
      } catch (Exception e){
      e.printStackTrace();
    }

  }

  public static void readPerformance(CodaClientLocalInterface li, int id){
    BufferedReader din = null;
    System.out.println(" Client1 is about to read....");
    
    byte[] dataArr = new byte[objSize];
    for(int i = 0; i < objSize; i++){
      dataArr[i] = 'a';
    }
    long start, end, totalMS;

    try{
      //din = new BufferedReader(new InputStreamReader(System.in));
      //din.readLine();
      start = System.currentTimeMillis();
      /*
      for(int i = 0; i < totalWrites; i++){
        ObjId objId = new ObjId("/"+i);
        li.write(objId, 0, objSize, dataArr);
      }
      end = System.currentTimeMillis();
      System.out.println(" write performance: " + ((end-start)/(double)totalWrites)
                         + " ms " + "dataSize= " + objSize);

      */
      start = System.currentTimeMillis();
      int count = 0;
      for(int i = 0; i < totalWrites; i++){
	if((i % clientNum)==id){
	  ObjId objId = new ObjId("/"+i);
	  li.read(objId, 0, objSize);
	  count++;
	}
      }
      end = System.currentTimeMillis();
      System.out.println(" read performance: " + ((end-start)/(double)totalWrites)
                         + " ms " + "dataSize= " + objSize + 
			 " total writes=" + count);
    } catch (Exception e){
      e.printStackTrace();
    }

  }

  public static void main(String[] argv)
  throws Exception{
    
    if(argv.length > 0){
      clientNum = new Integer(argv[0]).intValue();
    }
    makePractiConfig(CONFIG_PATH);
    //    makeP2Config(CONFIG_P2_PATH);
    //    makeNodeIdMap(NODEID_MAP_PATH);

    //
    // Start barrier server
    //
    //BarrierServer barrier = new BarrierServer(BARRIER_PORT, 2, BarrierServer.LOOP_FOREVER);
    //barrier.start();
    
    NodeId myNodeId = new NodeId(CLIENT1_ID);
    NodeId serverId = new NodeId(SERVER_ID);
    
    //create everything -- URANode
    RMIClient rmiClient = new RMIClient();
    boolean filterOn = true;
    boolean cleanDb = true;
    boolean noSyncLog = true;

    CodaMailBox mb = new CodaMailBox();
    Core core = new Core(rmiClient, filterOn, cleanDb, myNodeId, noSyncLog);
    Controller controller = new CodaClientExpt2Controller(rmiClient, myNodeId, 
							  serverId, mb, clientNum-1);
    RMIServerImpl rmiServer = new RMIServerImpl(core, controller);
    rmiServer.start();
    SocketServer socketServer = new SocketServer(core, controller);
    
    LocalInterface localInterface = new LocalInterface(controller, core);
    CodaClientLocalInterface li = new CodaClientLocalInterface(localInterface, myNodeId, 
							       serverId, rmiClient, mb);
    
    core.recoverLocalState(rmiServer);
    BarrierClient bc = new BarrierClient(CLIENT_1, BARRIER_PORT, 1);
    Env.dprintln(dbg, "uraNode created");
    bc.sendBarrierRequest(0, 1); // 1 We are up and running; helper is up
    Env.dprintln(dbg, "Client1 runing");

    try{
      
      //client --> server for "/*" subscriptionset
      //rmiClient.subscribeInval(myNodeId, serverId.getIDint(), "/*", true);
      //server --> client for empty subscriptionset
      rmiClient.subscribeInval(serverId, myNodeId.getIDint(), "/never", true);

      
     
    }catch(Exception e){
      e.printStackTrace();
      assert false: "can't subscribe between client and server";
    }
    Env.dprintln(dbg, "Client1 stage 1");
    bc.sendBarrierRequest(0, 1); // 2 initial subscription done

    Env.dprintln(dbg, "Client1 stage 2");
    Env.dprintln(dbg, "Client1 read");
    //readPerformance(li);
    ReadThread r1 = new ReadThread(li, 0);//senderID
    ReadThread r2 = new ReadThread(li, 1);
    r1.start(); 
    r2.start();
    r1.join();
    r2.join();
    bc.sendBarrierRequest(0, 1); // 3 wait for client do first round write + read
    Env.dprintln(dbg, "Client1 stage 3");
    
    //shutdown
    rmiServer.close();
    rmiServer = null;
    socketServer.shutdown();
    socketServer = null;
    core.syncStateToDisk();
    core.close();
    core = null;
  }
}

//----------------------------------------------------------------------------
// Thread to insert a bunch of writes
//----------------------------------------------------------------------------
class ReadThread extends Thread{
  private CodaClientLocalInterface li=null;
  private int id=0;
  public ReadThread(CodaClientLocalInterface li, int id)
    throws Exception{
    this.li = li;
    this.id = id;
  }
  public void run(){
    CodaExpt2Client1.readPerformance(li, id);
    return;
  }	
}
//---------------------------------------------------------------------------
/* $Log: CodaExpt2Client1.java,v $
/* Revision 1.3  2007/10/09 02:29:39  zjiandan
/* *** empty log message ***
/*
/* Revision 1.2  2007/10/07 05:19:22  zjiandan
/* *** empty log message ***
/*
/* Revision 1.1  2007/10/07 04:53:11  zjiandan
/*  coopeartive cachine
/**/
 /** 
