 /** 
 *  synchronization between Coda localinterface and P2  
 **/ 

import java.util.Hashtable;

public class CodaMailBox{
  private Hashtable writeFinishedTable;
  private boolean quitAll;
  static final boolean dbg = true;
 /** 
 *  Constructor 
 **/ 
  public
    CodaMailBox(){
    this.writeFinishedTable = new Hashtable();
    quitAll = false;
  }
  
 /** 
 *  clear all waiting threads with ServerDisconnectedException 
 **/ 
  synchronized public void quitAll(){
    //Env.dprintln(dbg, "mailBox::quitAll()");
    quitAll = true;
    notifyAll();
  }

 /** 
 *  clear all waiting threads with ServerDisconnectedException 
 **/ 
  synchronized public void waitForReset(){
    //Env.dprintln(dbg, "mailBox::waitForReset()");
    while((writeFinishedTable.size() != 0)&&quitAll){
      try{
	wait();
      }catch(InterruptedException e){
	//ignore;
      }
    }
    quitAll = false;
    //Env.dprintln(dbg, "mailBox::waitForReset() done");
  }
  
 /** 
 * called by P2 tuple writeFinished handler to notify write done. 
 **/ 
  synchronized public void got(AcceptStamp as){
    //Env.dprintln(dbg, "mailBox::got "+as.toString());
    writeFinishedTable.put(as, as);
    notifyAll();
    //Env.dprintln(dbg, "mailBox::got "+as.toString() + "done");
  }

 /** 
 * called by Coda LocalInterface to wait for p2 notify writeFinished 
 **/ 
  synchronized public void waitFor(AcceptStamp as)
  throws ServerDisconnectedException{
    //Env.dprintln(dbg, "mailBox::waitfor "+as.toString());
    while((!quitAll)&&(writeFinishedTable.get(as) == null)){
      try{
	wait();
      }catch(InterruptedException e){
	//ignore
      }     
    }
    if(quitAll){
      throw new ServerDisconnectedException();
    }else{
      assert writeFinishedTable.get(as) != null;
      writeFinishedTable.remove(as);
    }
    //Env.dprintln(dbg, "mailBox::got "+as.toString() + " done");
  }
  
 /** 
 *  unit test 
 **/ 
  public static void main(String[] argv){
    
  }
}

 /** 
/* $Log: CodaMailBox.java,v $
/* Revision 1.1  2007/10/07 04:53:11  zjiandan
/*  coopeartive cachine
/* */
 **/ 
