 /** 
/* CreateConfigForExpt1
 *
 * generate config files on subset
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.File;

public class CreateConfigForExpt1{
  
  protected static long NODE_0_ID = 0;
  protected static long NODE_1_ID = 1;
  protected static long NODE_2_ID = 2;
  protected static long NODE_3_ID = 3;
  protected static long NODE_4_ID = 4;
  protected static String NODE_0_IP = "128.83.145.1";//snapdragon
  protected static String NODE_1_IP = "128.83.145.2";//jasmine
  protected static String NODE_2_IP = "128.83.145.3";//zinnia
  protected static String NODE_3_IP = "128.83.143.1";//aralia
  protected static String NODE_4_IP = "128.83.144.1";//orchid

  
  protected static String NODE_0_HOST = "snapdragon.csres.utexas.edu";//snapdragon
  protected static String NODE_1_HOST = "jasmine.csres.utexas.edu";//jasmine
  protected static String NODE_2_HOST = "zinnia.csres.utexas.edu";//zinnia
  protected static String NODE_3_HOST = "aralia.csres.utexas.edu";//aralia
  protected static String NODE_4_HOST = "orchid.csres.utexas.edu";//orchid
  /*
  protected static String NODE_0_HOST = "snapdragon";//snapdragon
  protected static String NODE_1_HOST = "jasmine";//jasmine
  protected static String NODE_2_HOST = "zinnia";//zinnia
  protected static String NODE_3_HOST = "aralia";//aralia
  protected static String NODE_4_HOST = "orchid";//orchid
  */  
 /** 
 *  Make configuration files 
 **/ 
  public static void makeConfigs(String configPathPrefix){
    makePractiConfig(configPathPrefix + ".config");
    makeP2Config(configPathPrefix + ".p2config");
    makeNodeIdMap(configPathPrefix + ".map");
  }
  private static void makePractiConfig(String configPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(NODE_0_ID),
                            NODE_0_IP,
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "pfsexpt1-" + 
			    NODE_0_ID + ".db",
                            "/*",
                            -1L,
                            NODE_0_IP,
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(NODE_1_ID),
			   NODE_1_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "pfsexpt1-" + 
			   NODE_1_ID+".db",
			   "/*",
			   -1L,
			   NODE_1_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   Config.addOneNodeConfig(new NodeId(NODE_2_ID),
			   NODE_2_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "pfsexpt1-" + 
			   NODE_2_ID+".db",
			   "/*",
			   -1L,
			   NODE_2_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.addOneNodeConfig(new NodeId(NODE_3_ID),
			   NODE_3_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "pfsexpt1-" + 
			   NODE_3_ID+".db",
			   "/*",
			   -1L,
			   NODE_3_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    
   
   
   
   Config.addOneNodeConfig(new NodeId(NODE_4_ID),
			   NODE_4_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "pfsexpt1-" + 
			   NODE_4_ID+".db",
			   "/*",
			   -1L,
			   NODE_4_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   Config.writeToFile(configPath);
  }

  private static void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(NODE_0_ID), 1, 1, 300000, 300000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(NODE_1_ID), 1, 1, 300000, 300000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(NODE_2_ID), 1, 1, 300000, 300000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(NODE_3_ID), 1, 1, 300000, 300000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(NODE_4_ID), 1, 1, 300000, 300000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  private static void makeNodeIdMap(String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(NODE_0_ID), new OverlogId(NODE_0_IP + ":5000"));
    NodeIdMap.add(new NodeId(NODE_1_ID), new OverlogId(NODE_1_IP + ":5001"));
    NodeIdMap.add(new NodeId(NODE_2_ID), new OverlogId(NODE_2_IP + ":5002"));
    NodeIdMap.add(new NodeId(NODE_3_ID), new OverlogId(NODE_3_IP + ":5003"));
    NodeIdMap.add(new NodeId(NODE_4_ID), new OverlogId(NODE_4_IP + ":5004"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }

}