 /** 
/* InformGoldNodeHandler.java
 *
 * Handle "informGoldNode(ME, ObjId, GoldNode)" Tuple received from P2 
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

public class InformGoldNodeHandler extends TupleHandler{
  static final boolean sanityCheck = true;
  PangaeaFS pfs;
  public InformGoldNodeHandler(PangaeaFS pfs){
    super("informGoldNode");
    this.pfs = pfs;
  }

  public void handleTuple(Tuple tp)
    throws MalformedTupleException{
    if(tp.getLength() != 4) {
      throw new MalformedTupleException("tp=" + tp);
    }
    //assert tp.getItem(1)== myoverlogid;
    String objIdStr = tp.getItem(2);

    if(sanityCheck){
      NodeId gid = NodeIdMap.getNodeId(new OverlogId(tp.getItem(3)));
    }
    if(OverlogPolicy.P2VersionHasStringProblem){
      objIdStr = objIdStr.replace("-", "/");
      
    }

    pfs.informGoldNode(new ObjId(objIdStr), tp.getItem(3));
  }
}

 /** 
/* $Log: InformGoldNodeHandler.java,v $
/* Revision 1.5  2007/09/12 19:08:39  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.4  2007/01/10 06:34:01  zjiandan
/* fixed "mount: localhost:practidir: can't read superblock" problem
/* and the Java P2 wrapper string problem.
/*
/* Revision 1.3  2006/11/14 02:02:15  zjiandan
/* Compiled Pangaea NFS version with some UnitTests.
/*
/* Revision 1.2  2006/11/02 21:11:19  zjiandan
/* Fixed some bugs in URAOverlogNode and TupleHandlers.
/*
/* Revision 1.1  2006/11/01 19:26:46  zjiandan
/* Integrate PangaeaFS and NFS interface.
/* */
 **/ 
