 /** 
 *  Local interface created for PangaeaFS 
 **/ 
import java.util.HashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Iterator;
import java.io.IOException;
import java.io.EOFException;

public class PangaeaLocalInterface extends PRACTIFSLocalInterface{

 /** 
 *  Data members 
 **/ 
  

 /** 
 *  Constructor 
 **/ 
  public
  PangaeaLocalInterface(LocalInterface li, NodeId myNodeId){
    super(li, myNodeId, false);
  }

 /** 
 *  Constructor 
 **/ 
  public
  PangaeaLocalInterface(PRACTIFSLocalInterface li, NodeId myNodeId){
    super(li, myNodeId);
  }

 /** 
 *  Read from an object  
 *  Pangaea sepcific parameters: 
 *      blockValid = true; blockPrecise = false 
 **/ 
  public synchronized BodyMsg
  read(ObjId objId,
       long offset,
       long length)
    throws ObjNotFoundException, IOException,
	   EOFException, ReadOfHoleException{
    BodyMsg result = null;

    try{
      result = this.li.read(objId,
                            offset,
                            length,
                            true,//blockValid
                            false);//blockPrecise
    }catch(ReadOfInvalidRangeException rire){
      assert false;//because of blockValid is true
    }
    return(result);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    Env.verifyAssertEnabled();
    System.out.println("Testing PangaeaLocalInterface.java...");
    PangaeaLocalInterface.testSimple();
    System.out.println("...PangaeaLocalInterface.java");
    System.exit(0);
  }

 /** 
 *  Used for testing 
 **/ 
  private static void
  testSimple(){
    PangaeaLocalInterface li = null;
    FakePRACTIFSLocalInterface fakeLI = null;
    PRACTIFSReadLockToken readToken = null;
    PRACTIFSWriteLockToken writeToken = null;

    fakeLI = new FakePRACTIFSLocalInterface(new NodeId(1));
    li = new PangaeaLocalInterface(fakeLI, new NodeId(1));
    try{
      // Try one objId
      readToken = li.acquireReadLock(new ObjId("a"));
      assert(readToken.getObjId().equals(new ObjId("a")));
      assert(readToken.isAcquired());
      li.releaseReadLock(readToken, new ObjId("a"));
      assert(!readToken.isAcquired());
      writeToken = li.acquireWriteLock(new ObjId("a"));
      assert(writeToken.getObjId().equals(new ObjId("a")));
      assert(writeToken.isAcquired());
      li.releaseWriteLock(writeToken, new ObjId("a"));
      assert(!writeToken.isAcquired());

      // Try two objIds
      readToken = li.acquireReadLock(new ObjId("a"));
      assert(readToken.getObjId().equals(new ObjId("a")));
      assert(readToken.isAcquired());
      writeToken = li.acquireWriteLock(new ObjId("b"));
      assert(writeToken.getObjId().equals(new ObjId("b")));
      assert(writeToken.isAcquired());
      li.releaseWriteLock(writeToken, new ObjId("b"));
      li.releaseReadLock(readToken, new ObjId("a"));
    }catch(InterruptedException e){
      System.err.println("" + e);
    }
  }
}
 /** 
/* $Log: PangaeaLocalInterface.java,v $
/* Revision 1.10  2007/03/01 07:54:53  zjiandan
/* TierStore overlog and test helper, tested without PRACTI.
/*
/* Revision 1.9  2007/02/27 04:44:41  zjiandan
/* change readOfHole interface such that read of hole will throw an
/* ReadOfHoleException with the position of the next written byte.
/*
/* Revision 1.8  2007/02/12 06:19:49  zjiandan
/* Expose noSyncLog parameter, add more unittest for PRACTIFS, PangaeaFS.
/*
/* Revision 1.7  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.6  2007/01/10 04:01:50  nalini
/* updated read interface
/*
/* Revision 1.5  2006/11/18 08:13:55  nayate
/* Added code to catch ReadOfImpreciseObjException when appropriate
/*
/* Revision 1.4  2006/11/17 20:04:33  zjiandan
/* Tested new PRACTIFS.
/*
/* Revision 1.3  2006/11/15 08:06:43  nayate
/* Added a parameter to the PRACTIFSLocalInterface constructor
/*
/* Revision 1.2  2006/11/14 02:02:15  zjiandan
/* Compiled Pangaea NFS version with some UnitTests.
/* */
 **/ 
