 /** 
/* PangaeaURAOverlogNode.java
 *
 * Create Practi URANode and Overlog Engine, and a PangaeaFS (local interface)
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;
import java.util.*;

public class PangaeaURAOverlogNode extends URAOverlogNode{
  final static long primary = 0;
  final static boolean dbg = true;
  final PangaeaFS pfs;
  final PangaeaLocalInterface pli;
  public PangaeaURAOverlogNode(String configPath, 
                               String p2ConfigPath, 
                               NodeId nodeId,
                               boolean cleanDb,
                               String overlogPath,
                               String nodeMapPath,
			       boolean noSyncLog){
    
    super(configPath, p2ConfigPath, nodeId, cleanDb, overlogPath, nodeMapPath, noSyncLog);
    //super.getP2Runtime().getCore().setCatchupTypeToCP(true);//set the catchup type to be CP
    assert false: "add CP to all subscribeInval tuple in Pangaea.olg";
    Env.dprintln(dbg, "creating PangaeaFS");
    pli = new PangaeaLocalInterface(li, nodeId);
    pfs = new PangaeaFS(pli,
                        overlogPolicy, nodeId.equals(new NodeId(primary)));
    Env.dprintln(dbg, "creating PangaeaFS done");
    //overlogPolicy.registerHandler(new GetGoldNodesHandler(pfs));
    // Env.dprintln(dbg, "creating PangaeaFS done 1");
    overlogPolicy.registerHandler(new InformGoldNodeHandler(pfs));
    Env.dprintln(dbg, "creating PangaeaFS done 2");
    overlogPolicy.registerHandler(new ReplaceDeadGoldHandler(pfs));  
    if(dbg){
      System.out.println("PangaeaURAOverlogNode( " + configPath + ", "
                         + p2ConfigPath + ", "
                         + nodeId + ", "
                         + overlogPath + ", "
                         + nodeMapPath + ") starts ...");
    }
    try{
      super.start();
    }catch(Exception e){
      e.printStackTrace();
      System.exit(1);
    }

  }

  public PangaeaFS getFS(){
    return pfs;
  }

  public void userInterface(InputStream is){
    boolean dbgWriteScript = false;
    
    long accumulatedTimeMillis = 0;
    long nextWriteExpectedTime = System.currentTimeMillis();
    long startTime = System.currentTimeMillis();
    long writeNum = 0;

    Env.printDebug("Enter action:  ");
    Env.printDebug("Comments       : c [comments]");
    Env.printDebug("write          : w [ObjId] [String]");
    Env.printDebug("GetAcceptStamp : r [ObjId] [String]");
    Env.printDebug("end            : e");

    BufferedReader din = null;
		
    try{
	    		
      din = new BufferedReader(new InputStreamReader(is));
		
	    
      String input;
      for(input = din.readLine(); input!= null; input=din.readLine()) {
        
        System.err.println("Input : " + input);
        byte[] action = input.getBytes();
		
        if(action[0] == 'w'){
          writeNum++;
          StringTokenizer st = new StringTokenizer(input.substring(2));
          ObjId objId = new ObjId(st.nextToken());
          String str = "";
	  while(st.hasMoreElements()){
	    str = str+st.nextToken();
	    str += " ";
	  }
	  str.trim();
         
	  Env.dprintln(dbg, "str to write to object " + objId.toString()+ ":" + str);
	  try{
	    PRACTIFileOutputStream pos = new PRACTIFileOutputStream(this.pli, objId);
	    ObjectOutputStream oos = new ObjectOutputStream(pos);
	    //setup the tree: mazzola  --> rossi --> boniperti
	  
	    oos.writeObject(str);
	    oos.flush();
	  }catch(Exception e){
	    e.printStackTrace();
	    //continue
	  }
		    
        } else if (action[0] == 'r'){//blockRead send READ_DONE at the end
	  StringTokenizer st = new StringTokenizer(input.substring(2));
          ObjId objId = new ObjId(st.nextToken());
          String str = "";
	  
          PRACTIFileInputStream pis = null;
          ObjectInputStream ois = null;
          try{
	    pis = new PRACTIFileInputStream(this.pli, objId, 1000);
	    ois = new ObjectInputStream(pis);
	    
	    str = (String)(ois.readObject());
	    
	    Env.dprintln(dbg, "read object " + objId.toString() + " :" + str);
	    
          }catch(Exception e){
            //
            // ObjNotFoundException or EOFException
            //
	    e.printStackTrace();
	    //continue;
          }
                    
        } else if (action[0] == 'e'){
          System.exit(-1);

       
        } else if (action[0] == 'c'){
          // Do nothing
        } 
      }//for
    } catch (Exception e){
      e.printStackTrace();
      Env.printDebug("Wrong input format ...");
    }	
  }
  
  public static void main(String[] argv)
    throws Exception{
    PangaeaURAOverlogNode uraNode = new PangaeaURAOverlogNode("test/pfs_rossi_boniperti.config",
                                                              "test/pfs_rossi_boniperti.p2config",
                                                              new NodeId(0),
                                                              true,
                                                              "case-studies/Pangaea/PangaeaTopology_rbm.olg",
                                                              "test/pfs_rossi_boniperti.map", false);
    Env.dprintln(dbg, "uraNode created");
    uraNode.userInterface(System.in);
    
  }

  
}

 /** 
/* $Log: PangaeaURAOverlogNode.java,v $
/* Revision 1.12  2007/06/04 21:41:00  zjiandan
/* expose stream catchup type CP|LOG option to rmiClient.subscribeInval().
/*
/* Revision 1.11  2007/03/06 18:25:52  zjiandan
/* Add optimization for CatchupInvalIterator, fixed SubscriptionSet, HierInvalTarget
/* and P2Runtime problems. Add aways split when receiving subtree ISStatus in Checkpoint.
/*
/* Revision 1.10  2007/02/27 04:44:41  zjiandan
/* change readOfHole interface such that read of hole will throw an
/* ReadOfHoleException with the position of the next written byte.
/*
/* Revision 1.9  2007/02/12 06:19:49  zjiandan
/* Expose noSyncLog parameter, add more unittest for PRACTIFS, PangaeaFS.
/*
/* Revision 1.8  2007/01/10 06:34:02  zjiandan
/* fixed "mount: localhost:practidir: can't read superblock" problem
/* and the Java P2 wrapper string problem.
/*
/* Revision 1.7  2007/01/10 04:02:56  nalini
/* minor fix
/*
/* Revision 1.6  2006/11/15 08:06:59  nayate
/* Added a parameter to the PRACTIFSLocalInterface constructor
/*
/* Revision 1.5  2006/11/14 02:02:15  zjiandan
/* Compiled Pangaea NFS version with some UnitTests.
/*
/* Revision 1.4  2006/11/02 21:28:39  zjiandan
/* fixed some minor bugs and turn off the debug printing.
/*
/* Revision 1.3  2006/11/02 21:11:19  zjiandan
/* Fixed some bugs in URAOverlogNode and TupleHandlers.
/*
/* Revision 1.2  2006/11/01 23:48:59  zjiandan
/* fix incommingConnectionUnit problem caused by the changed Core interface.
/*
/* Revision 1.1  2006/11/01 19:26:46  zjiandan
/* Integrate PangaeaFS and NFS interface.
/* */
 **/ 
