 /** 
/* ReplaceDeadGoldHandler.java
 *
 * Handle "replaceDeadGold(ME, ObjId, DeadNode, NewGoldNode)" Tuple received from P2 
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

public class ReplaceDeadGoldHandler extends TupleHandler{
  
  PangaeaFS pfs;
  public ReplaceDeadGoldHandler(PangaeaFS pfs){
    super("replaceDeadGold");
    this.pfs = pfs;
  }

  public void handleTuple(Tuple tp)
    throws MalformedTupleException{
    if(tp.getLength() != 5) {
      throw new MalformedTupleException();
    }
    String objIdStr = tp.getItem(2);
    NodeId deadGold = NodeIdMap.getNodeId(new OverlogId(tp.getItem(3)));
    NodeId newGold = NodeIdMap.getNodeId(new OverlogId(tp.getItem(4)));

    if(OverlogPolicy.P2VersionHasStringProblem){
      objIdStr = objIdStr.replace("-", "/");      
    }

    
    pfs.replaceDeadGold(new ObjId(objIdStr), deadGold, newGold);
  }
}

 /** 
/* $Log: ReplaceDeadGoldHandler.java,v $
/* Revision 1.3  2007/09/12 19:08:39  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.2  2006/11/02 21:11:19  zjiandan
/* Fixed some bugs in URAOverlogNode and TupleHandlers.
/*
/* Revision 1.1  2006/11/01 19:26:46  zjiandan
/* Integrate PangaeaFS and NFS interface.
/* */
 **/ 
